/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    private static ParseField INDEX_FILTER_FIELD = new ParseField("index_filter", new String[0]);
    private static ParseField RUNTIME_MAPPINGS_FIELD = new ParseField("runtime_mappings", new String[0]);
    private static final ObjectParser<FieldCapabilitiesRequest, Void> PARSER = new ObjectParser("field_caps_request");

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/_field_caps"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_field_caps"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_field_caps")));
    }

    @Override
    public String getName() {
        return "field_capabilities_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        FieldCapabilitiesRequest fieldRequest = new FieldCapabilitiesRequest().fields(Strings.splitStringByCommaToArray(request.param("fields"))).indices(indices);
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        fieldRequest.includeUnmapped(request.paramAsBoolean("include_unmapped", false));
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> {
            if (parser != null) {
                PARSER.parse(parser, (Object)fieldRequest, null);
            }
        }));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.fieldCaps(fieldRequest, new RestToXContentListener<FieldCapabilitiesResponse>((RestChannel)channel));
        };
    }

    static {
        PARSER.declareObject(FieldCapabilitiesRequest::indexFilter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), INDEX_FILTER_FIELD);
        PARSER.declareObject(FieldCapabilitiesRequest::runtimeFields, (p, c) -> p.map(), RUNTIME_MAPPINGS_FIELD);
    }
}

