/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.CreateApiKeyRequest;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class GrantApiKeyRequest
implements Validatable,
ToXContentObject {
    private final Grant grant;
    private final CreateApiKeyRequest apiKeyRequest;

    public GrantApiKeyRequest(Grant grant, CreateApiKeyRequest apiKeyRequest) {
        this.grant = Objects.requireNonNull(grant, "Grant may not be null");
        this.apiKeyRequest = Objects.requireNonNull(apiKeyRequest, "Create API key request may not be null");
    }

    public Grant getGrant() {
        return this.grant;
    }

    public CreateApiKeyRequest getApiKeyRequest() {
        return this.apiKeyRequest;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.grant.toXContent(builder, params);
        builder.field("api_key", (ToXContent)this.apiKeyRequest);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantApiKeyRequest that = (GrantApiKeyRequest)o;
        return Objects.equals(this.grant, that.grant) && Objects.equals(this.apiKeyRequest, that.apiKeyRequest);
    }

    public int hashCode() {
        return Objects.hash(this.grant, this.apiKeyRequest);
    }

    public static class Grant
    implements ToXContentFragment {
        private final String grantType;
        private final String username;
        private final char[] password;
        private final String accessToken;

        private Grant(String grantType, String username, char[] password, String accessToken) {
            this.grantType = Objects.requireNonNull(grantType, "Grant type may not be null");
            this.username = username;
            this.password = password;
            this.accessToken = accessToken;
        }

        public static Grant passwordGrant(String username, char[] password) {
            return new Grant("password", Objects.requireNonNull(username, "Username may not be null"), Objects.requireNonNull(password, "Password may not be null"), null);
        }

        public static Grant accessTokenGrant(String accessToken) {
            return new Grant("access_token", null, null, Objects.requireNonNull(accessToken, "Access token may not be null"));
        }

        public String getGrantType() {
            return this.grantType;
        }

        public String getUsername() {
            return this.username;
        }

        public char[] getPassword() {
            return this.password;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("grant_type", this.grantType);
            if (this.username != null) {
                builder.field("username", this.username);
            }
            if (this.password != null) {
                byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])this.password);
                try {
                    builder.field("password").utf8Value(passwordBytes, 0, passwordBytes.length);
                }
                finally {
                    Arrays.fill(passwordBytes, (byte)0);
                }
            }
            if (this.accessToken != null) {
                builder.field("access_token", this.accessToken);
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Grant grant = (Grant)o;
            return this.grantType.equals(grant.grantType) && Objects.equals(this.username, grant.username) && Arrays.equals(this.password, grant.password) && Objects.equals(this.accessToken, grant.accessToken);
        }

        public int hashCode() {
            int result = Objects.hash(this.grantType, this.username, this.accessToken);
            result = 31 * result + Arrays.hashCode(this.password);
            return result;
        }
    }
}

