/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.bearer.UserRolesResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;

public class MSGraphUserRolesResolver
implements UserRolesResolver {
    public static URL memberOfEndpoint;
    @Autowired
    OIDCConfiguration oidcConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveUrl(String accessToken) throws IOException {
        String tokenHeaderValue = "Bearer " + accessToken;
        String tokenHeaderName = "Authorization";
        HttpURLConnection http = null;
        try {
            String result;
            http = (HttpURLConnection)memberOfEndpoint.openConnection();
            http.setRequestProperty("Accept", "application/json");
            http.setRequestProperty(tokenHeaderName, tokenHeaderValue);
            String string = result = new BufferedReader(new InputStreamReader(http.getInputStream())).lines().collect(Collectors.joining("\n"));
            return string;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    public List<String> parseJson(String jsonString) throws JSONException {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject json = new JSONObject(jsonString);
        JSONArray values = json.getJSONArray("value");
        for (int i = 0; i < values.length(); ++i) {
            JSONObject object = (JSONObject)values.get(i);
            if (!object.get("@odata.type").equals("#microsoft.graph.group")) continue;
            result.add(object.get("id").toString());
        }
        return result;
    }

    @Override
    public List<String> resolveRoles(String tokenValue, Map claims, OidcUserInfo userInfo) throws Exception {
        String jsonStr = this.resolveUrl(tokenValue);
        List<String> result = this.parseJson(jsonStr);
        return result;
    }

    static {
        try {
            memberOfEndpoint = new URL("https://graph.microsoft.com/v1.0/me/memberOf");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

