/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.ldap.LdapUsernameToDnMapper;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.util.Assert;

public class SearchingLdapUsernameToDnMapper
implements LdapUsernameToDnMapper {
    private LdapContextSource ldapContextSource;
    private LdapUserSearch ldapUserSearch;

    public void setLdapContextSource(LdapContextSource source) {
        this.ldapContextSource = source;
    }

    public void setLdapUserSearch(LdapUserSearch ldapUserSearch) {
        this.ldapUserSearch = ldapUserSearch;
    }

    public DistinguishedName buildDn(String username) {
        Assert.notNull((Object)this.ldapContextSource, (String)"ldapContextSource is not injected");
        Assert.notNull((Object)this.ldapUserSearch, (String)"ldapUserSearch is not injected");
        if (username.contains("*")) {
            throw new RuntimeException("Security violation - LDAP username contains *!");
        }
        DirContextOperations result = this.ldapUserSearch.searchForUser(username);
        return new DistinguishedName(result.getDn());
    }
}

