/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.oaipmh.OaiPmhService;
import org.fao.geonet.kernel.oaipmh.ResumptionTokenCache;
import org.fao.geonet.kernel.oaipmh.services.GetRecord;
import org.fao.geonet.kernel.oaipmh.services.Identify;
import org.fao.geonet.kernel.oaipmh.services.ListIdentifiers;
import org.fao.geonet.kernel.oaipmh.services.ListMetadataFormats;
import org.fao.geonet.kernel.oaipmh.services.ListRecords;
import org.fao.geonet.kernel.oaipmh.services.ListSets;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.server.OaiPmhFactory;
import org.fao.oaipmh.util.Lib;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;

public class OaiPmhDispatcher {
    public static final int MODE_MODIFIDATE = 2;
    public static final int MODE_TEMPEXTEND = 1;
    private ResumptionTokenCache cache;
    private HashMap<String, OaiPmhService> hmServices = new HashMap();

    public OaiPmhDispatcher(SettingManager sm, SchemaManager scm) {
        this.cache = new ResumptionTokenCache(sm);
        this.register(new GetRecord());
        this.register(new Identify());
        this.register(new ListIdentifiers(this.cache, sm, scm));
        this.register(new ListMetadataFormats());
        this.register(new ListRecords(this.cache, sm, scm));
        this.register(new ListSets());
    }

    private void register(OaiPmhService s) {
        this.hmServices.put(s.getVerb(), s);
    }

    public Element dispatch(Element request, ServiceContext context) {
        Element response = this.dispatchI(request, context);
        this.validateResponse(context, response);
        return response;
    }

    private Element dispatchI(Element request, ServiceContext context) {
        String url = null;
        Map params = null;
        SettingInfo si = context.getBean(SettingInfo.class);
        try {
            url = si.getSiteUrl() + context.getBaseUrl() + "/" + "srv" + "/en/" + context.getService();
            params = OaiPmhFactory.extractParams((Element)request);
            AbstractRequest req = OaiPmhFactory.parse((ConfigurableApplicationContext)context.getApplicationContext(), (Map)params);
            OaiPmhService srv = this.hmServices.get(req.getVerb());
            AbstractResponse res = srv.execute(req, context);
            Element response = res.toXml();
            return Lib.createOaiRoot((String)url, (Map)params, (Element)response);
        }
        catch (OaiPmhException e) {
            return OaiPmhException.marshal((OaiPmhException)e, url, params);
        }
        catch (Exception e) {
            context.info("Exception stack trace : \n" + Util.getStackTrace((Throwable)e));
            BadArgumentException ex = new BadArgumentException("Internal error : " + e.getMessage());
            return OaiPmhException.marshal((OaiPmhException)ex, (String)url, (Map)params);
        }
    }

    private void validateResponse(ServiceContext context, Element response) {
        Path schema = context.getAppPath().resolve("xml/validation/oai/OAI-PMH.xsd");
        if (context.isDebugEnabled()) {
            context.debug("Validating against : " + schema);
        }
        try {
            Xml.validate((Path)schema, (Element)response);
        }
        catch (Exception e) {
            context.warning("OAI-PMH response does not validate : " + e.getMessage());
        }
    }

    @PreDestroy
    public void shutdown() {
        Log.info((String)"jeeves.engine", (Object)"OaiPmhDispatcher#shutdown");
        this.cache.stopRunning();
        this.cache = null;
    }
}

