/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.i18n;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.standards.StandardsUtils;
import org.fao.geonet.api.tools.i18n.TranslationType;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.Translations;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.TranslationsRepository;
import org.fao.geonet.util.XslUtil;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class TranslationPackBuilder {
    @Autowired
    TranslationPackBuilder self;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    MetadataCategoryRepository categoryRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    SchematronRepository schematronRepository;
    @Autowired
    IsoLanguageRepository isoLanguageRepository;
    @Autowired
    TranslationsRepository translationsRepository;
    @Autowired
    SchemaManager schemaManager;
    Path jsonLocaleDirectory;
    @Resource(name="translationPacks")
    private Map<String, List<String>> packages;
    private static final String TYPE_SEPARATOR = "/";
    private static final String LIST_SEPARATOR = "\\+";
    private static final List<String> TRANSLATION_TABLES = Arrays.asList("StatusValue", "MetadataCategory", "Group", "Operation", "Source", "Schematron", "IsoLanguage", "Translations");

    public Map<String, List<String>> getPackages() {
        return this.packages;
    }

    public void setPackages(Map<String, List<String>> packages) {
        this.packages = packages;
    }

    @PostConstruct
    public void init() {
        this.jsonLocaleDirectory = this.dataDirectory.getWebappDir().endsWith("src/main/webapp") ? this.dataDirectory.getWebappDir().getParent().getParent().getParent().getParent().resolve("web-ui/src/main/resources/catalog/locales") : this.dataDirectory.getWebappDir().resolve("catalog").resolve("locales");
    }

    @Cacheable(value={"translations"}, cacheManager="cacheManager", key="{#language, #key}")
    public Map<String, String> getPack(String language, String key, ServiceContext context) {
        HashMap translations = new HashMap();
        if (this.packages.get(key) == null) {
            throw new IllegalArgumentException(String.format("Package '%s' not found. Choose one of %s or add '%s' to the config-spring-geonetwork.xml translationPacks config.", key, this.packages.keySet().toString(), key));
        }
        this.packages.get(key).forEach(resource -> {
            String[] config = resource.split(TYPE_SEPARATOR);
            if (config[0].equals(TranslationType.json.name())) {
                String[] fileKeys = config[1].split(LIST_SEPARATOR);
                translations.putAll(this.self.getJsonTranslation(language, Arrays.asList(fileKeys)));
            } else if (config[0].equals(TranslationType.db.name())) {
                String[] fileKeys = config[1].split(LIST_SEPARATOR);
                translations.putAll(this.self.getDbTranslation(language, Arrays.asList(fileKeys)));
            } else if (config[0].equals(TranslationType.standards.name()) && config.length == 4) {
                String[] codelistKeys = config[3].split(LIST_SEPARATOR);
                if ("labels".equals(config[2])) {
                    translations.putAll(this.self.getStandardLabel(language, config[1], Arrays.asList(codelistKeys), context));
                } else {
                    translations.putAll(this.self.getStandardCodelist(language, config[1], Arrays.asList(codelistKeys), context));
                }
            } else {
                throw new IllegalArgumentException(String.format("Package resource type '%s' in package '%s' is not supported. Choose one of %s.", config[0], key, Arrays.stream(TranslationType.values()).map(v -> v.name()).collect(Collectors.joining(", "))));
            }
        });
        TreeMap<String, String> orderedTranslations = new TreeMap<String, String>();
        orderedTranslations.putAll(translations);
        return orderedTranslations;
    }

    @Cacheable(value={"translations"}, cacheManager="cacheManager", key="{#schema, #language, #codelist}")
    public Map<String, String> getStandardCodelist(String language, String schema, List<String> codelist, ServiceContext context) {
        HashMap<String, String> translations = new HashMap<String, String>();
        context.setLanguage(language);
        for (String c : codelist) {
            Element e = null;
            try {
                e = StandardsUtils.getCodelist(c, this.schemaManager, schema, null, null, null, context, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            List listOfEntry = e.getChildren("entry");
            for (Element entry : listOfEntry) {
                translations.put(entry.getChildText("code"), entry.getChildText("label"));
            }
        }
        return translations;
    }

    @Cacheable(value={"translations"}, cacheManager="cacheManager", key="{#schema, #language, #label}")
    public Map<String, String> getStandardLabel(String language, String schema, List<String> label, ServiceContext context) {
        HashMap<String, String> translations = new HashMap<String, String>();
        context.setLanguage(language);
        for (String c : label) {
            Element e = null;
            try {
                e = StandardsUtils.getLabel(c, this.schemaManager, schema, null, null, null, null, context);
                translations.put(c.split(":")[1], e.getChildText("label"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return translations;
    }

    @Cacheable(value={"translations"}, cacheManager="cacheManager")
    public Map<String, String> getDbTranslation(String language, List<String> type) {
        HashMap<String, String> translations = new HashMap<String, String>();
        this.validateDbType(type);
        if (type == null || type.contains("StatusValue")) {
            List valueList = this.statusValueRepository.findAll();
            for (StatusValue entity : valueList) {
                String label = this.getLabelOrKey((Localized)entity, language, entity.getId() + "");
                translations.put("status-" + entity.getId(), label);
                translations.put("status-" + entity.getName(), label);
            }
        }
        if (type == null || type.contains("MetadataCategory")) {
            List metadataCategoryList = this.categoryRepository.findAll();
            for (StatusValue entity : metadataCategoryList) {
                translations.put("cat-" + entity.getName(), this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Group")) {
            List groupList = this.groupRepository.findAll();
            for (StatusValue entity : groupList) {
                translations.put("group-" + entity.getId(), this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Operation")) {
            List operationList = this.operationRepository.findAll();
            for (StatusValue entity : operationList) {
                translations.put("op-" + entity.getId(), this.getLabelOrKey((Localized)entity, language, String.valueOf(entity.getId())));
                translations.put("op-" + entity.getName(), this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Source")) {
            List sourceList = this.sourceRepository.findAll();
            for (StatusValue entity : sourceList) {
                translations.put("source-" + entity.getUuid(), this.getLabelOrKey((Localized)entity, language, entity.getUuid()));
            }
        }
        if (type == null || type.contains("Schematron")) {
            List schematronList = this.schematronRepository.findAll();
            for (StatusValue entity : schematronList) {
                translations.put("sch-" + entity.getRuleName(), this.getLabelOrKey((Localized)entity, language, entity.getRuleName()));
            }
        }
        if (type == null || type.contains("IsoLanguage")) {
            List isoLanguageList = this.isoLanguageRepository.findAll();
            for (StatusValue entity : isoLanguageList) {
                translations.put("lang-" + entity.getCode(), this.getLabelOrKey((Localized)entity, language, entity.getCode()));
            }
        }
        if (type == null || type.contains("Translations")) {
            translations.putAll(this.getAllDbTranslations(language));
        }
        return translations;
    }

    @Cacheable(value={"translations"}, cacheManager="cacheManager")
    public Map<String, String> getJsonTranslation(String language, List<String> fileNameKeys) {
        HashMap<String, String> translations = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        String iso2letterLangCode = XslUtil.twoCharLangCode(language, "eng");
        fileNameKeys.forEach(key -> {
            if (key.equals("schemas")) {
                this.schemaManager.getSchemas().forEach(s -> {
                    String filename = String.format("/META-INF/catalog/locales/%s-schema-%s.json", iso2letterLangCode, s);
                    ClassPathResource resource = new ClassPathResource(filename);
                    if (resource.exists()) {
                        try (InputStream stream = resource.getInputStream();){
                            translations.putAll((Map)mapper.readValue(stream, Map.class));
                        }
                        catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                    }
                });
            } else {
                String filename = String.format("%s-%s.json", iso2letterLangCode, key);
                Path jsonFile = this.jsonLocaleDirectory.resolve(filename);
                if (jsonFile.toFile().exists()) {
                    try {
                        translations.putAll((Map)mapper.readValue(jsonFile.toFile(), Map.class));
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            }
        });
        return translations;
    }

    @CacheEvict(value={"translations"}, cacheManager="cacheManager", allEntries=true)
    public void clearCache() {
    }

    public Map<String, String> getAllDbTranslations(String language) {
        HashMap<String, String> translations = new HashMap<String, String>();
        List translationsList = this.translationsRepository.findAllByLangId(language);
        for (Translations entity : translationsList) {
            translations.put(entity.getFieldName(), StringUtils.isNotEmpty((String)entity.getValue()) ? entity.getValue() : entity.getFieldName());
        }
        return translations;
    }

    private String getLabelOrKey(Localized entity, String language, String defaultValue) {
        String value = entity.getLabel(language);
        return value != null ? value : defaultValue;
    }

    private void validateDbType(List<String> type) {
        if (type != null) {
            if (type.size() == 0) {
                throw new IllegalArgumentException(String.format("Empty type is not allowed. Remove the parameter or choose one or more types in %s", TRANSLATION_TABLES));
            }
            for (String value : type) {
                if (TRANSLATION_TABLES.contains(value)) continue;
                throw new IllegalArgumentException(String.format("Type '%s' is not allowed. Choose one or more types in %s", value, TRANSLATION_TABLES));
            }
        }
    }
}

