/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.dispatchers;

import com.yammer.metrics.core.TimerContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.component.ProfileManager;
import jeeves.interfaces.Service;
import jeeves.monitor.MonitorManager;
import jeeves.monitor.timer.ServiceManagerGuiServicesTimer;
import jeeves.monitor.timer.ServiceManagerServicesTimer;
import jeeves.monitor.timer.ServiceManagerXslOutputTransformTimer;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ErrorPage;
import jeeves.server.dispatchers.OutputPage;
import jeeves.server.dispatchers.ServiceInfo;
import jeeves.server.dispatchers.guiservices.Call;
import jeeves.server.dispatchers.guiservices.GuiService;
import jeeves.server.dispatchers.guiservices.XmlFile;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.http.HttpServiceRequest;
import jeeves.server.sources.http.JeevesServlet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.io.EofException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.exceptions.NotAllowedEx;
import org.fao.geonet.exceptions.ServiceNotFoundEx;
import org.fao.geonet.exceptions.ServiceNotMatchedEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.BLOB;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.SOAPUtil;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;

public class ServiceManager {
    private Map<String, ArrayList<ServiceInfo>> htServices = new HashMap<String, ArrayList<ServiceInfo>>(100);
    private Map<String, Object> htContexts = new HashMap<String, Object>();
    private List<ErrorPage> vErrorPipe = new ArrayList<ErrorPage>();
    private List<GuiService> vDefaultGui = new ArrayList<GuiService>();
    private String baseUrl;
    private long maxUploadSize;
    private String defaultLang;
    private String defaultContType;
    private boolean defaultLocal;
    private JeevesServlet servlet;
    private boolean startupError = false;
    private Map<String, String> startupErrors;
    @PersistenceContext
    private EntityManager entityManager;

    static void info(String message) {
        Log.info((String)"jeeves.service", (Object)message);
    }

    static void error(String message) {
        Log.error((String)"jeeves.service", (Object)message);
    }

    public void setDefaultLang(String lang) {
        this.defaultLang = lang;
    }

    public void setDefaultContType(String type) {
        this.defaultContType = type;
    }

    public void setMaxUploadSize(long size) {
        this.maxUploadSize = size;
    }

    public void setDefaultLocal(boolean yesno) {
        this.defaultLocal = yesno;
    }

    public void setServlet(JeevesServlet serv) {
        this.servlet = serv;
    }

    public void setStartupErrors(Map<String, String> errors) {
        this.startupErrors = errors;
        this.startupError = true;
    }

    public boolean isStartupError() {
        return this.startupError;
    }

    public void setBaseUrl(String name) {
        this.baseUrl = name;
        if (!this.baseUrl.startsWith("/") && this.baseUrl.length() != 0) {
            this.baseUrl = "/" + this.baseUrl;
        }
    }

    public void registerContext(String name, Object context) {
        this.htContexts.put(name, context);
    }

    public void addDefaultGui(Element gui) throws Exception {
        this.vDefaultGui.add(this.getGuiService("", gui));
    }

    public ServiceInfo addService(String pack, Element srv, Path appPath) throws Exception {
        String name = srv.getAttributeValue("name");
        String match = srv.getAttributeValue("match");
        String sheet = srv.getAttributeValue("sheet");
        String cache = srv.getAttributeValue("cache");
        ServiceInfo si = (ServiceInfo)ApplicationContextHolder.get().getBean(ServiceInfo.class);
        si.setMatch(match);
        si.setSheet(sheet);
        si.setCache(cache);
        ArrayList<ServiceInfo> al = this.htServices.get(name);
        if (al == null) {
            al = new ArrayList();
            this.htServices.put(name, al);
        } else {
            ServiceManager.info("Service " + name + " already exist, re-register it.");
            this.htServices.remove(name);
            al = new ArrayList();
            this.htServices.put(name, al);
        }
        al.add(si);
        List classes = srv.getChildren("class");
        for (Object classe : classes) {
            si.addService(this.buildService(pack, (Element)classe, appPath));
        }
        List outputs = srv.getChildren("output");
        for (Element output : outputs) {
            si.addOutputPage(this.buildOutputPage(pack, output));
        }
        List errors = srv.getChildren("error");
        for (Element error : errors) {
            si.addErrorPage(this.buildErrorPage(error));
        }
        return si;
    }

    private Service buildService(String pack, Element clas, Path appPath) throws Exception {
        String name = clas.getAttributeValue("name");
        if (name == null) {
            throw new IllegalArgumentException("Missing 'name' attrib in 'class' element");
        }
        if (name.startsWith(".")) {
            name = pack + name;
        }
        Service service = (Service)Class.forName(name).newInstance();
        service.init(appPath, new ServiceConfig(clas.getChildren("param")));
        return service;
    }

    private OutputPage buildOutputPage(String pack, Element output) throws Exception {
        OutputPage outPage = new OutputPage();
        outPage.setStyleSheet(output.getAttributeValue("sheet"));
        outPage.setForward(output.getAttributeValue("forward"));
        outPage.setTestCondition(output.getAttributeValue("test"));
        outPage.setFile(output.getAttributeValue("file") != null);
        outPage.setBLOB(output.getAttributeValue("blob") != null);
        String contType = output.getAttributeValue("contentType");
        if (contType == null) {
            contType = this.defaultContType;
        }
        outPage.setContentType(contType);
        List guiList = output.getChildren();
        for (Element gui : guiList) {
            outPage.addGuiService(this.getGuiService(pack, gui));
        }
        return outPage;
    }

    private GuiService getGuiService(String pack, Element elem) throws Exception {
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        if ("xml".equals(elem.getName())) {
            return new XmlFile(elem, this.defaultLang, this.defaultLocal);
        }
        if ("call".equals(elem.getName())) {
            return new Call(elem, pack, dataDirectory.getWebappDir());
        }
        throw new IllegalArgumentException("Unknown GUI element : " + Xml.getString((Element)elem));
    }

    private ErrorPage buildErrorPage(Element err) throws Exception {
        int statusCode;
        ErrorPage errPage = new ErrorPage();
        errPage.setStyleSheet(err.getAttributeValue("sheet"));
        errPage.setTestCondition(err.getAttributeValue("id"));
        String contType = err.getAttributeValue("contentType");
        if (contType == null) {
            contType = this.defaultContType;
        }
        errPage.setContentType(contType);
        String strStatusCode = err.getAttributeValue("statusCode");
        try {
            statusCode = Integer.parseInt(strStatusCode);
        }
        catch (Exception e) {
            statusCode = 500;
        }
        errPage.setStatusCode(statusCode);
        List guiList = err.getChildren();
        for (Element gui : guiList) {
            errPage.addGuiService(this.getGuiService("?", gui));
        }
        return errPage;
    }

    public void addErrorPage(Element err) throws Exception {
        this.vErrorPipe.add(this.buildErrorPage(err));
    }

    public ServiceContext createServiceContext(String name, ConfigurableApplicationContext appContext) {
        ServiceContext context = new ServiceContext(name, appContext, this.htContexts, this.entityManager);
        context.setBaseUrl(this.baseUrl);
        context.setLanguage("?");
        context.setUserSession(null);
        context.setIpAddress("?");
        context.setMaxUploadSize(this.maxUploadSize);
        context.setServlet(this.servlet);
        return context;
    }

    public static String getRequestIpAddress(HttpServletRequest request) {
        String xForwardedForHeader = request.getHeader("x-forwarded-for");
        return StringUtils.isNotEmpty((String)xForwardedForHeader) ? xForwardedForHeader : request.getRemoteAddr();
    }

    public ServiceContext createServiceContext(String name, String lang, HttpServletRequest request) {
        UserSession session;
        ServiceContext context = new ServiceContext(name, ApplicationContextHolder.get(), this.htContexts, this.entityManager);
        context.setBaseUrl(this.baseUrl);
        context.setLanguage(lang);
        context.setIpAddress(ServiceManager.getRequestIpAddress(request));
        context.setMaxUploadSize(this.maxUploadSize);
        context.setServlet(this.servlet);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (session = (UserSession)httpSession.getAttribute("session")) != null) {
            context.setUserSession(session);
        }
        return context;
    }

    public void dispatch(ServiceRequest req, UserSession session) {
        ServiceContext context = new ServiceContext(req.getService(), ApplicationContextHolder.get(), this.htContexts, this.entityManager);
        this.dispatch(req, session, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(ServiceRequest req, UserSession session, ServiceContext context) {
        context.setBaseUrl(this.baseUrl);
        context.setLanguage(req.getLanguage());
        context.setUserSession(session);
        context.setIpAddress(req.getAddress());
        context.setMaxUploadSize(this.maxUploadSize);
        context.setInputMethod(req.getInputMethod());
        context.setOutputMethod(req.getOutputMethod());
        context.setHeaders(req.getHeaders());
        context.setServlet(this.servlet);
        if (this.startupError) {
            context.setStartupErrors(this.startupErrors);
        }
        context.setAsThreadLocal();
        Element response = null;
        ServiceInfo srvInfo = null;
        try {
            while (true) {
                OutputPage outputPage;
                String forward;
                String srvName = req.getService();
                ServiceManager.info("Dispatching : " + srvName);
                this.logParameters(req.getParams());
                ArrayList<ServiceInfo> al = this.htServices.get(srvName);
                if (al == null) {
                    ServiceManager.error("Service not found : " + srvName);
                    throw new ServiceNotFoundEx(srvName);
                }
                for (ServiceInfo serviceInfo : al) {
                    if (!serviceInfo.matches(req.getParams())) continue;
                    srvInfo = serviceInfo;
                    break;
                }
                if (srvInfo == null) {
                    ServiceManager.error("Service not matched in list : " + srvName);
                    throw new ServiceNotMatchedEx(srvName);
                }
                TimerContext timerContext = this.getMonitorManager().getTimer(ServiceManagerServicesTimer.class).time();
                try {
                    response = srvInfo.execServices(req.getParams(), context);
                }
                finally {
                    timerContext.stop();
                }
                for (Map.Entry<String, String> entry : context.getResponseHeaders().entrySet()) {
                    ((HttpServiceRequest)req).getHttpServletResponse().setHeader(entry.getKey(), entry.getValue());
                }
                if (context.getStatusCode() != null) {
                    req.setStatusCode(context.getStatusCode());
                }
                if ((forward = this.dispatchOutput(req, context, response, outputPage = srvInfo.findOutputPage(response), srvInfo.isCacheSet())) == null) {
                    ServiceManager.info(" -> dispatch ended for : " + srvName);
                    return;
                }
                ServiceManager.info(" -> forwarding to : " + forward);
                if (srvName.equals("metadata.quiet.delete") || srvName.equals("user.login") || srvName.equals("user.logout")) {
                    HttpServiceRequest req2 = (HttpServiceRequest)req;
                    req2.getHttpServletResponse().setStatus(301);
                    req2.getHttpServletResponse().setHeader("Location", this.baseUrl + "/" + ((NodeInfo)context.getApplicationContext().getBean(NodeInfo.class)).getId() + "/" + req.getLanguage() + "/" + forward);
                    return;
                }
                Element elForward = new Element("forward");
                elForward.setAttribute("service", srvName);
                response.setName("request");
                response.addContent((Content)elForward);
                context.setService(forward);
                req.setService(forward);
                req.setParams(response);
            }
        }
        catch (Throwable e) {
            if (e instanceof NotAllowedEx) {
                throw (NotAllowedEx)e;
            }
            this.handleError(req, response, context, srvInfo, e);
            return;
        }
    }

    private MonitorManager getMonitorManager() {
        return (MonitorManager)ApplicationContextHolder.get().getBean(MonitorManager.class);
    }

    private void handleError(ServiceRequest req, Element response, ServiceContext context, ServiceInfo srvInfo, Throwable e) {
        boolean cache;
        Element error = this.getError(req, e, response);
        String id = error.getAttributeValue("id");
        int code = this.getErrorCode(e);
        boolean bl = cache = srvInfo != null && srvInfo.isCacheSet();
        if (this.isDebug()) {
            this.debug("Raised exception while executing service\n" + Xml.getString((Element)error));
        }
        try {
            ServiceRequest.InputMethod input = req.getInputMethod();
            ServiceRequest.OutputMethod output = req.getOutputMethod();
            if (input == ServiceRequest.InputMethod.SOAP || output == ServiceRequest.OutputMethod.SOAP) {
                req.setStatusCode(code);
                req.beginStream("application/soap+xml; charset=UTF-8", cache);
                error.setAttribute("encodingStyle", "http://www.geonetwork.org/encoding/error", SOAPUtil.NAMESPACE_ENV);
                boolean sender = code < 500;
                String message = error.getChildText("class") + " : " + error.getChildText("message");
                req.write(SOAPUtil.embedExc((Element)error, (boolean)sender, (String)id, (String)message));
            } else if (input == ServiceRequest.InputMethod.XML || output == ServiceRequest.OutputMethod.XML) {
                req.setStatusCode(code);
                req.beginStream("application/xml; charset=UTF-8", cache);
                req.write(error);
            } else {
                ErrorPage errPage = null;
                if (srvInfo != null) {
                    errPage = srvInfo.findErrorPage(id);
                }
                if (errPage == null) {
                    errPage = this.findErrorPage(id);
                }
                try {
                    this.dispatchError(req, context, error, errPage, cache);
                }
                catch (Exception ex) {
                    req.setStatusCode(code);
                    req.beginStream("application/xml; charset=UTF-8", cache);
                    req.write(error);
                }
            }
        }
        catch (Exception ex) {
            ServiceManager.error("Raised exception while writing response to exception");
            ServiceManager.error("  Exception : " + ex);
            ServiceManager.error("  Message   : " + ex.getMessage());
            ServiceManager.error("  Stack     : " + Util.getStackTrace((Throwable)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dispatchOutput(ServiceRequest req, ServiceContext context, Element response, OutputPage outPage, boolean cache) throws Exception {
        String sForward;
        ServiceManager.info("   -> dispatching to output for : " + req.getService());
        if (outPage != null && (sForward = outPage.getForward()) != null) {
            return sForward;
        }
        GeonetworkDataDirectory dataDirectory = context.getBean(GeonetworkDataDirectory.class);
        if (outPage == null) {
            if (response == null) {
                this.warning("Response is null and there is no output page for : " + req.getService());
            } else {
                ServiceManager.info("     -> writing xml for : " + req.getService());
                if (this.isDebug()) {
                    this.debug("Service xml is :\n" + Xml.getString((Element)response));
                }
                ServiceRequest.InputMethod in = req.getInputMethod();
                ServiceRequest.OutputMethod out = req.getOutputMethod();
                if (in == ServiceRequest.InputMethod.SOAP || out == ServiceRequest.OutputMethod.SOAP) {
                    if (context.getStatusCode() != null) {
                        req.setStatusCode(context.getStatusCode());
                    }
                    req.beginStream("application/soap+xml; charset=UTF-8", cache);
                    if (!SOAPUtil.isEnvelope((Element)response)) {
                        response = SOAPUtil.embed((Element)response);
                    }
                    req.write(response);
                } else if (req.hasJSONOutput()) {
                    req.beginStream("application/json; charset=UTF-8", cache);
                    req.getOutputStream().write(Xml.getJSON((Element)response).getBytes(Constants.ENCODING));
                    req.endStream();
                } else if (response.getAttribute("redirect") != null) {
                    HttpServiceRequest req2 = (HttpServiceRequest)req;
                    req2.getHttpServletResponse().setStatus(301);
                    req2.getHttpServletResponse().setHeader("Location", response.getAttribute("url").getValue());
                    req2.getHttpServletResponse().setHeader("Content-type", response.getAttribute("mime-type").getValue());
                } else {
                    req.beginStream("application/xml; charset=UTF-8", cache);
                    req.write(response);
                }
            }
        } else {
            NodeInfo nodeInfo = context.getBean(NodeInfo.class);
            if (outPage.isFile()) {
                long cl;
                BinaryFile binaryFile;
                String contentType;
                if (outPage.getContentType().equals("application/pdf") && !outPage.getStyleSheet().equals("")) {
                    Element guiElem;
                    Path styleSheet = IO.toPath((String)outPage.getStyleSheet(), (String[])new String[0]);
                    TimerContext guiServicesTimerContext = context.getMonitorManager().getTimer(ServiceManagerGuiServicesTimer.class).time();
                    try {
                        guiElem = outPage.invokeGuiServices(context, response, this.vDefaultGui);
                    }
                    finally {
                        guiServicesTimerContext.stop();
                    }
                    this.addPrefixes(guiElem, context.getLanguage(), req.getService(), nodeInfo.getId());
                    Element rootElem = new Element("root").addContent((Content)guiElem).addContent((Content)response);
                    Element reqElem = (Element)req.getParams().clone();
                    reqElem.setName("request");
                    rootElem.addContent((Content)reqElem);
                    styleSheet = dataDirectory.resolveWebResource("xsl/").resolve(styleSheet);
                    if (!Files.exists(styleSheet, new LinkOption[0])) {
                        ServiceManager.error(" -> stylesheet not found on disk, aborting : " + styleSheet);
                    } else {
                        ServiceManager.info(" -> transforming with stylesheet : " + styleSheet);
                        try {
                            Path file;
                            TimerContext timerContext = context.getMonitorManager().getTimer(ServiceManagerXslOutputTransformTimer.class).time();
                            try {
                                file = Xml.transformFOP((Path)dataDirectory.getUploadDir(), (Element)rootElem, (String)styleSheet.toString());
                            }
                            finally {
                                timerContext.stop();
                            }
                            String documentName = guiElem.getChildText("documentFileName");
                            if (StringUtils.isEmpty((String)documentName)) {
                                documentName = "document.pdf";
                            } else {
                                if (!documentName.endsWith(".pdf")) {
                                    documentName = documentName + ".pdf";
                                }
                                Calendar c = Calendar.getInstance();
                                documentName = documentName.replace("{year}", c.get(1) + "");
                                documentName = documentName.replace("{month}", c.get(2) + "");
                                documentName = documentName.replace("{day}", c.get(5) + "");
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                                SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                                documentName = documentName.replace("{date}", dateFormat.format(c.getTime()));
                                documentName = documentName.replace("{datetime}", datetimeFormat.format(c.getTime()));
                            }
                            response = BinaryFile.encode((int)200, (Path)file, (String)documentName, (boolean)true).getElement();
                        }
                        catch (Exception e) {
                            ServiceManager.error(" -> exception during XSL/FO transformation for : " + req.getService());
                            ServiceManager.error(" -> (C) stylesheet : " + styleSheet);
                            ServiceManager.error(" -> (C) message : " + e.getMessage());
                            ServiceManager.error(" -> (C) exception : " + e.getClass().getSimpleName());
                            throw e;
                        }
                        ServiceManager.info(" -> end transformation for : " + req.getService());
                    }
                }
                if ((contentType = (binaryFile = new BinaryFile(response)).getContentType()) == null) {
                    contentType = "application/octet-stream";
                }
                String contentDisposition = binaryFile.getContentDisposition();
                String contentLength = binaryFile.getContentLength();
                long l = cl = contentLength == null ? -1L : Long.parseLong(contentLength);
                if (context.getStatusCode() != null) {
                    req.setStatusCode(context.getStatusCode());
                }
                req.beginStream(contentType, cl, contentDisposition, cache);
                binaryFile.write(req.getOutputStream());
                req.endStream();
                binaryFile.removeIfTheCase();
            } else if (outPage.isBLOB()) {
                String contentType = BLOB.getContentType((Element)response);
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                String contentDisposition = BLOB.getContentDisposition((Element)response);
                String contentLength = BLOB.getContentLength((Element)response);
                long cl = contentLength == null ? -1L : Long.parseLong(contentLength);
                req.beginStream(contentType, cl, contentDisposition, cache);
                BLOB.write((Element)response, (OutputStream)req.getOutputStream());
                req.endStream();
            } else {
                Element guiElem;
                Path styleSheet = IO.toPath((String)outPage.getStyleSheet(), (String[])new String[0]);
                TimerContext guiServicesTimerContext = this.getMonitorManager().getTimer(ServiceManagerGuiServicesTimer.class).time();
                try {
                    guiElem = outPage.invokeGuiServices(context, response, this.vDefaultGui);
                }
                finally {
                    guiServicesTimerContext.stop();
                }
                this.addPrefixes(guiElem, context.getLanguage(), req.getService(), nodeInfo.getId());
                Element rootElem = new Element("root").addContent((Content)guiElem).addContent((Content)response);
                Element reqElem = (Element)req.getParams().clone();
                reqElem.setName("request");
                rootElem.addContent((Content)reqElem);
                if (req.hasDebug()) {
                    req.beginStream("application/xml; charset=UTF-8", cache);
                    req.write(rootElem);
                } else {
                    styleSheet = dataDirectory.getWebappDir().resolve("xsl/").resolve(styleSheet);
                    if (!Files.exists(styleSheet, new LinkOption[0])) {
                        ServiceManager.error("     -> stylesheet not found on disk, aborting : " + styleSheet);
                    } else {
                        block58: {
                            ServiceManager.info("     -> transforming with stylesheet : " + styleSheet);
                            try {
                                if (req.hasJSONOutput()) {
                                    Element xsltResponse = null;
                                    TimerContext timerContext = context.getMonitorManager().getTimer(ServiceManagerXslOutputTransformTimer.class).time();
                                    try {
                                        xsltResponse = Xml.transform((Element)rootElem, (Path)styleSheet);
                                    }
                                    finally {
                                        timerContext.stop();
                                    }
                                    req.beginStream("application/json; charset=UTF-8", cache);
                                    req.getOutputStream().write(Xml.getJSON((Element)xsltResponse).getBytes(Constants.ENCODING));
                                    req.endStream();
                                    break block58;
                                }
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                TimerContext timerContext = context.getMonitorManager().getTimer(ServiceManagerXslOutputTransformTimer.class).time();
                                try {
                                    Xml.transform((Element)rootElem, (Path)styleSheet, (OutputStream)baos);
                                }
                                finally {
                                    timerContext.stop();
                                }
                                if (outPage.getContentType() != null && outPage.getContentType().startsWith("text/plain")) {
                                    req.beginStream(outPage.getContentType(), -1L, "attachment;", cache);
                                } else {
                                    req.beginStream(outPage.getContentType(), cache);
                                }
                                req.getOutputStream().write(baos.toByteArray());
                                req.endStream();
                            }
                            catch (EofException baos) {
                            }
                            catch (Exception e) {
                                ServiceManager.error("   -> exception during transformation for : " + req.getService());
                                ServiceManager.error("   ->  (C) stylesheet : " + styleSheet);
                                ServiceManager.error("   ->  (C) message    : " + e.getMessage());
                                ServiceManager.error("   ->  (C) exception  : " + e.getClass().getSimpleName());
                                throw e;
                            }
                        }
                        ServiceManager.info("     -> end transformation for : " + req.getService());
                    }
                }
            }
        }
        ServiceManager.info("   -> output ended for : " + req.getService());
        return null;
    }

    private void dispatchError(ServiceRequest req, ServiceContext context, Element response, ErrorPage outPage, boolean cache) throws Exception {
        ServiceManager.info("   -> dispatching to error for : " + req.getService());
        Path styleSheet = IO.toPath((String)outPage.getStyleSheet(), (String[])new String[0]);
        Element guiElem = outPage.invokeGuiServices(context, response, this.vDefaultGui);
        req.setStatusCode(outPage.getStatusCode());
        this.addPrefixes(guiElem, context.getLanguage(), req.getService(), context.getBean(NodeInfo.class).getId());
        Element rootElem = new Element("root").addContent((Content)guiElem).addContent((Content)response);
        if (req.hasDebug()) {
            req.beginStream("application/xml; charset=UTF-8", cache);
            req.write(rootElem);
        } else {
            styleSheet = context.getBean(GeonetworkDataDirectory.class).resolveWebResource("xsl/").resolve(styleSheet);
            ServiceManager.info("     -> transforming with stylesheet : " + styleSheet);
            try {
                req.beginStream(outPage.getContentType(), cache);
                Xml.transform((Element)rootElem, (Path)styleSheet, (OutputStream)req.getOutputStream());
                req.endStream();
            }
            catch (EofException eofException) {
            }
            catch (Exception e) {
                Log.error((String)"jeeves", (String)e.getMessage(), (Throwable)e);
            }
        }
        ServiceManager.info("     -> end error transformation for : " + req.getService());
        ServiceManager.info("   -> error ended for : " + req.getService());
    }

    private ErrorPage findErrorPage(String id) {
        for (int i = 0; i < this.vErrorPipe.size(); ++i) {
            ErrorPage p = this.vErrorPipe.get(i);
            if (!p.matches(id)) continue;
            return p;
        }
        ServiceManager.error("No default error found for id : " + id);
        throw new NullPointerException("No default error found for id : " + id);
    }

    private Element getError(ServiceRequest req, Throwable t, Element response) {
        Element params = new Element("request").addContent((Content)new Element("language").setText(req.getLanguage())).addContent((Content)new Element("service").setText(req.getService()));
        Element error = JeevesException.toElement((Throwable)t).addContent((Content)params);
        if (response != null) {
            error.addContent((Content)((Element)response.clone()));
        }
        return error;
    }

    private int getErrorCode(Throwable t) {
        int code = 500;
        if (t instanceof JeevesException) {
            code = ((JeevesException)t).getCode();
        }
        return code;
    }

    private void addPrefixes(Element root, String lang, String service, String nodeId) {
        root.addContent((Content)new Element("language").setText(lang));
        root.addContent((Content)new Element("lang2chars").setText(XslUtil.twoCharLangCode(lang)));
        root.addContent((Content)new Element("reqService").setText(service));
        root.addContent((Content)new Element("url").setText(this.baseUrl));
        root.addContent((Content)new Element("locUrl").setText(this.baseUrl + "/loc/" + lang));
        root.addContent((Content)new Element("service").setText(this.baseUrl + "/" + nodeId));
        root.addContent((Content)new Element("nodeId").setText(nodeId));
        root.addContent((Content)new Element("locService").setText(this.baseUrl + "/" + nodeId + "/" + lang));
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        root.addContent((Content)new Element("nodeUrl").setText(settingManager.getNodeURL()));
        root.addContent((Content)new Element("baseUrl").setText(settingManager.getBaseURL()));
        root.addContent((Content)new Element("serverUrl").setText(settingManager.getServerURL()));
    }

    private void logParameters(Element params) {
        List paramsList = params.getChildren();
        if (paramsList.size() == 0) {
            if (this.isDebug()) {
                this.debug(" -> no input parameters");
            } else if (this.isDebug()) {
                this.debug(" -> parameters are : \n" + Xml.getString((Element)params));
            }
        }
    }

    private boolean isDebug() {
        return Log.isDebugEnabled((String)"jeeves.service");
    }

    private void debug(String message) {
        Log.debug((String)"jeeves.service", (Object)message);
    }

    private void warning(String message) {
        Log.warning((String)"jeeves.service", (Object)message);
    }

    public ProfileManager getProfileManager() {
        return (ProfileManager)ApplicationContextHolder.get().getBean(ProfileManager.class);
    }
}

