/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.GraphPatternQuery;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;

public class SelectQuery
extends GraphPatternQuery {
    private ProjectionElem[] _projection;

    public SelectQuery(List projection, GraphPattern graphPattern) {
        this(false, projection, graphPattern);
    }

    public SelectQuery(boolean distinct, List projection, GraphPattern graphPattern) {
        super(distinct, graphPattern);
        this.setProjection(projection);
    }

    public SelectQuery(boolean distinct, int offset, int limit, List projection, GraphPattern graphPattern) {
        super(distinct, offset, limit, graphPattern);
        this.setProjection(projection);
    }

    public ProjectionElem[] getProjection() {
        return this._projection;
    }

    public void setProjection(List projection) {
        ProjectionElem[] projArray = new ProjectionElem[projection.size()];
        projArray = projection.toArray(projArray);
        this.setProjection(projArray);
    }

    public void setProjection(ProjectionElem[] projection) {
        this._projection = projection;
    }

    public void getProjectionVariables(Collection variables) {
        for (int i = 0; i < this._projection.length; ++i) {
            this._projection[i].getValueExpr().getVariables(variables);
        }
    }

    public String[] getColumnHeaders() {
        String[] columnHeaders = new String[this._projection.length];
        for (int i = 0; i < this._projection.length; ++i) {
            columnHeaders[i] = this._projection[i].getName();
        }
        return columnHeaders;
    }

    protected boolean _reportQueryAnswer(RdfSource rdfSource, QueryAnswerListener listener) throws IOException {
        Value[] values = new Value[this._projection.length];
        for (int i = 0; i < this._projection.length; ++i) {
            values[i] = this._projection[i].getValueExpr().getValue();
        }
        return listener.queryAnswer(new QueryAnswer(values));
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("select ");
        if (this.isDistinct()) {
            result.append("distinct ");
        }
        for (int i = 0; i < this._projection.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this._projection[i].toString());
        }
        result.append("\nfrom\n");
        result.append(this.getGraphPattern().toString());
        if (this.hasLimit()) {
            result.append("\nlimit ").append(this.getLimit());
        }
        if (this.hasOffset()) {
            result.append("\noffset ").append(this.getOffset());
        }
        return result.toString();
    }
}

