/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.repository.GeonetRepository;
import org.fao.geonet.repository.MetadataRepositoryCustom;
import org.fao.geonet.repository.StreamableJpaSpecificationRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface MetadataRepository
extends GeonetRepository<Metadata, Integer>,
MetadataRepositoryCustom,
JpaSpecificationExecutor<Metadata>,
StreamableJpaSpecificationRepository<Metadata> {
    @Nullable
    public Metadata findOneById(int var1);

    @Nullable
    public Metadata findOneByUuid(@Nonnull String var1);

    @Nullable
    public List<Metadata> findAllByUuid(@Nonnull String var1);

    @Nonnull
    public List<Metadata> findAllByHarvestInfo_Uuid(@Nonnull String var1);

    @Query(value="SELECT replace(data, :search, :replace) FROM metadata m WHERE uuid = :uuid", nativeQuery=true)
    public String selectOneWithSearchAndReplace(@Param(value="uuid") String var1, @Param(value="search") String var2, @Param(value="replace") String var3);

    @Query(value="SELECT regexp_replace(data, :pattern, :replace) FROM metadata m WHERE uuid = :uuid", nativeQuery=true)
    public String selectOneWithRegexSearchAndReplace(@Param(value="uuid") String var1, @Param(value="pattern") String var2, @Param(value="replace") String var3);

    @Query(value="SELECT regexp_replace(data, :pattern, :replace, :flags) FROM metadata m WHERE uuid = :uuid", nativeQuery=true)
    public String selectOneWithRegexSearchAndReplaceWithFlags(@Param(value="uuid") String var1, @Param(value="pattern") String var2, @Param(value="replace") String var3, @Param(value="flags") String var4);
}

