/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.domain.converter.BooleanToYNConverter;
import org.fao.geonet.entitylistener.SourceEntityListenerManager;
import org.fao.geonet.repository.LanguageRepository;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="Sources")
@EntityListeners(value={SourceEntityListenerManager.class})
public class Source
extends Localized {
    public static final String TABLE_NAME = "Sources";
    public static final String ID_COLUMN_NAME = "uuid";
    public static final String CREATION_DATE_COLUMN_NAME = "creationDate";
    private String _uuid = UUID.randomUUID().toString();
    private String _name;
    private SourceType type = null;
    private String logo;
    private String filter;
    private String uiConfig;
    private String serviceRecord;
    private ISODate creationDate = new ISODate();
    private Integer groupOwner;
    private Boolean listableInHeaderSelector = true;

    public Source() {
    }

    public Source(String uuid, String name, Map<String, String> translations, SourceType type) {
        this._uuid = uuid;
        this.setName(name);
        if (translations != null && translations.size() != 0) {
            this.setLabelTranslations(translations);
        } else {
            LanguageRepository langRepository = (LanguageRepository)ApplicationContextHolder.get().getBean(LanguageRepository.class);
            List allLanguages = langRepository.findAll();
            Map<String, String> labelTranslations = this.getLabelTranslations();
            for (Language l : allLanguages) {
                String label = labelTranslations.get(l.getId());
                if (label != null) continue;
                this.getLabelTranslations().put(l.getId(), this.getName());
            }
        }
        this.type = type;
    }

    @Id
    @Column(name="uuid")
    public String getUuid() {
        return this._uuid;
    }

    public Source setUuid(String uuid) {
        this._uuid = uuid;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public Source setName(String name) {
        this._name = name;
        return this;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="SourcesDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false, length=255)
    @Nonnull
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return Objects.equals(this._uuid, source._uuid) && Objects.equals(this._name, source._name);
    }

    public int hashCode() {
        int result = this._uuid != null ? this._uuid.hashCode() : 0;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        return result;
    }

    @Column(nullable=true, name="type")
    @Enumerated(value=EnumType.STRING)
    public SourceType getType() {
        return this.type;
    }

    public Source setType(SourceType type) {
        this.type = type;
        return this;
    }

    public String getLogo() {
        return this.logo;
    }

    public Source setLogo(String logo) {
        this.logo = logo;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Source setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getUiConfig() {
        return this.uiConfig;
    }

    public Source setUiConfig(String uiConfig) {
        this.uiConfig = uiConfig;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="creationDate", nullable=true, length=30))
    public ISODate getCreationDate() {
        return this.creationDate;
    }

    public Source setCreationDate(ISODate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Column(name="groupOwner")
    public Integer getGroupOwner() {
        return this.groupOwner;
    }

    public Source setGroupOwner(Integer groupOwner) {
        this.groupOwner = groupOwner;
        return this;
    }

    @Column(name="serviceRecord")
    public String getServiceRecord() {
        return this.serviceRecord;
    }

    public void setServiceRecord(String serviceRecord) {
        this.serviceRecord = serviceRecord;
    }

    @Column(name="isListableInHeaderSelector", nullable=false, length=1, columnDefinition="CHAR(1) DEFAULT 'y'")
    @Convert(converter=BooleanToYNConverter.class)
    public boolean isListableInHeaderSelector() {
        return this.listableInHeaderSelector;
    }

    public void setListableInHeaderSelector(Boolean listableInHeaderSelector) {
        this.listableInHeaderSelector = listableInHeaderSelector;
    }
}

