/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public enum Profile {
    Administrator(new Profile[0]),
    UserAdmin(Administrator),
    Reviewer(UserAdmin),
    Editor(Reviewer),
    RegisteredUser(Editor),
    Guest(RegisteredUser),
    Monitor(Administrator);

    public static final String PROFILES_ELEM_NAME = "profiles";
    private final Set<Profile> parents;

    private Profile(Profile ... parents) {
        this.parents = new HashSet<Profile>(Arrays.asList(parents));
    }

    public static boolean exists(String profile) {
        try {
            Profile.valueOf(profile);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Profile findProfileIgnoreCase(String profileName) {
        for (Profile actualProfile : Profile.values()) {
            if (!actualProfile.name().equalsIgnoreCase(profileName)) continue;
            return actualProfile;
        }
        return null;
    }

    public Set<Profile> getChildren() {
        HashSet<Profile> children = new HashSet<Profile>();
        for (Profile profile : Profile.values()) {
            if (!profile.parents.contains((Object)this)) continue;
            children.add(profile);
        }
        return children;
    }

    public Set<Profile> getParents() {
        return this.parents;
    }

    public Set<Profile> getProfileAndAllChildren() {
        HashSet<Profile> profiles = new HashSet<Profile>();
        profiles.add(this);
        for (Profile child : this.getChildren()) {
            profiles.addAll(child.getProfileAndAllChildren());
        }
        return profiles;
    }

    public Set<Profile> getProfileAndAllParents() {
        HashSet<Profile> profiles = new HashSet<Profile>();
        profiles.add(this);
        for (Profile parent : this.getParents()) {
            profiles.addAll(parent.getProfileAndAllParents());
        }
        return profiles;
    }

    public Element asElement() {
        Element elResult = new Element(PROFILES_ELEM_NAME);
        for (Profile profile : this.getProfileAndAllChildren()) {
            if (profile == Guest) continue;
            elResult.addContent((Content)new Element(profile.name()));
        }
        return elResult;
    }

    public Set<String> getAllNames() {
        HashSet<String> names = new HashSet<String>();
        for (Profile p : this.getProfileAndAllChildren()) {
            names.add(p.name());
        }
        return names;
    }
}

