/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom.harvester;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.inspireatom.model.DatasetFeedInfo;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.repository.specification.InspireAtomFeedSpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.util.LogUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;

public class InspireAtomHarvester {
    private Logger logger = Log.createLogger((String)"geonetwork.atom");
    private GeonetContext gc;

    public InspireAtomHarvester(GeonetContext geonetContext) {
        this.gc = geonetContext;
    }

    public final Element harvest() {
        LogUtil.initializeHarvesterLog((String)"atom", (String)"atomharvester");
        EsSearchManager searchManager = (EsSearchManager)this.gc.getBean(EsSearchManager.class);
        SettingManager sm = (SettingManager)this.gc.getBean(SettingManager.class);
        DataManager dataMan = (DataManager)this.gc.getBean(DataManager.class);
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        String atomProtocol = sm.getValue("system/inspire/atomProtocol");
        List<AbstractMetadata> iso19139Metadata = InspireAtomUtil.searchMetadataByTypeAndProtocol(ServiceContext.get(), searchManager, "service", atomProtocol);
        Element result = new Element("response");
        try {
            this.logger.info("ATOM feed harvest started");
            this.logger.info("ATOM feed harvest: remove existing metadata feeds");
            repository.deleteAll();
            this.logger.info("ATOM feed harvest: retrieving service metadata feeds");
            Map<String, String> serviceMetadataWithAtomFeeds = InspireAtomUtil.retrieveServiceMetadataWithAtomFeeds(dataMan, iso19139Metadata, atomProtocol);
            this.logger.info("ATOM feed harvest: processing service metadata feeds (" + serviceMetadataWithAtomFeeds.size() + ")");
            List<DatasetFeedInfo> datasetsInformation = this.processServiceMetadataFeeds(dataMan, serviceMetadataWithAtomFeeds, result);
            this.logger.info("ATOM feed harvest: processing dataset metadata feeds (" + datasetsInformation.size() + ")");
            this.processDatasetsMetadataFeeds(dataMan, datasetsInformation, result);
            this.logger.info("ATOM feed harvest finished");
        }
        catch (Exception x) {
            this.logger.error("ATOM feed harvest error: " + x.getMessage());
            this.logger.error((Throwable)x);
            result.addContent((Content)new Element("error").setText(x.getMessage()));
        }
        return result;
    }

    public final void harvestServiceMetadata(ServiceContext context, String metadataId) {
        Logger localLogger = Log.createLogger((String)"geonetwork.atom");
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)context.getBean(InspireAtomFeedRepository.class);
        DataManager dataMan = (DataManager)context.getBean(DataManager.class);
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)this.gc.getBean(IMetadataUtils.class);
        AbstractMetadata iso19139Metadata = metadataUtils.findOne(Specification.where((Specification)MetadataSpecs.isType((MetadataType)MetadataType.METADATA)).and(MetadataSpecs.isIso19139Schema()).and(MetadataSpecs.hasMetadataId((int)Integer.parseInt(metadataId))));
        Element result = new Element("response");
        try {
            localLogger.info("ATOM feed harvest started for metadata: " + metadataId);
            String atomProtocol = sm.getValue("system/inspire/atomProtocol");
            localLogger.info("ATOM feed harvest: remove existing metadata feed");
            repository.deleteAll(InspireAtomFeedSpecs.hasMetadataId((int)Integer.parseInt(metadataId)));
            dataMan.indexMetadata(Arrays.asList(metadataId));
            localLogger.info("ATOM feed harvest: processing service metadata feeds");
            Map<String, String> serviceMetadataWithAtomFeed = InspireAtomUtil.retrieveServiceMetadataWithAtomFeed(dataMan, iso19139Metadata, atomProtocol);
            List<DatasetFeedInfo> datasetsInformation = this.processServiceMetadataFeeds(dataMan, serviceMetadataWithAtomFeed, result);
            localLogger.info("ATOM feed harvest for metadata: " + metadataId + ",  processing dataset metadata feeds");
            this.processDatasetsMetadataFeeds(dataMan, datasetsInformation, result);
            localLogger.info("ATOM feed harvest finished for metadata: " + metadataId);
        }
        catch (Exception x) {
            localLogger.error("ATOM feed harvest error: " + x.getMessage());
            localLogger.error((Throwable)x);
        }
    }

    private List<DatasetFeedInfo> processServiceMetadataFeeds(DataManager dataMan, Map<String, String> serviceMetadataWithAtomFeeds, Element result) throws Exception {
        ArrayList<DatasetFeedInfo> datasetsInformation = new ArrayList<DatasetFeedInfo>();
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        long total = serviceMetadataWithAtomFeeds.entrySet().size();
        long i = 1L;
        for (Map.Entry<String, String> entry : serviceMetadataWithAtomFeeds.entrySet()) {
            String metadataId = entry.getKey();
            String metadataUuid = dataMan.getMetadataUuid(metadataId);
            try {
                String atomUrl = entry.getValue();
                this.logger.info("Processing feed (" + i++ + "/" + total + ") for service metadata with uuid:" + metadataUuid);
                this.logger.info("Atom feed Url for service metadata (" + metadataUuid + "): " + atomUrl);
                String atomFeedDocument = InspireAtomUtil.retrieveRemoteAtomFeedDocument(this.gc, atomUrl);
                this.logger.debug("Atom feed Document for service metadata (" + metadataUuid + "): " + atomFeedDocument);
                Element atomDoc = Xml.loadString((String)atomFeedDocument, (boolean)false);
                if (!atomDoc.getNamespace().equals((Object)Geonet.Namespaces.ATOM)) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for service metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                InspireAtomFeed inspireAtomFeed = InspireAtomFeed.build((Element)atomDoc);
                inspireAtomFeed.setMetadataId(Integer.valueOf(Integer.parseInt(metadataId)));
                inspireAtomFeed.setAtomUrl(atomUrl);
                inspireAtomFeed.setAtom(atomFeedDocument);
                inspireAtomFeed.setAtomDatasetid("");
                inspireAtomFeed.setAtomDatasetns("");
                repository.save((Object)inspireAtomFeed);
                dataMan.indexMetadata(Arrays.asList(metadataId));
                this.logger.debug("Extract datasets information (identifier, namespace) from service atom feed  (" + atomUrl + ")");
                datasetsInformation.addAll(InspireAtomUtil.extractRelatedDatasetsInfoFromServiceFeed(atomFeedDocument, dataMan));
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("feed", atomUrl).setAttribute("status", "ok"));
            }
            catch (Exception ex) {
                this.logger.error("Failed to process atom feed for service metadata: " + metadataUuid + " " + ex.getMessage());
                this.logger.error((Throwable)ex);
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("error", ex.getMessage()).setAttribute("status", "error"));
            }
        }
        return datasetsInformation.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DatasetFeedInfo>(Comparator.comparing(DatasetFeedInfo::getIdentifier))), ArrayList::new));
    }

    private void processDatasetsMetadataFeeds(DataManager dataMan, List<DatasetFeedInfo> datasetsFeedInformation, Element result) {
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        long total = datasetsFeedInformation.size();
        long i = 1L;
        for (DatasetFeedInfo datasetFeedInfo : datasetsFeedInformation) {
            String metadataUuid = "";
            try {
                metadataUuid = InspireAtomUtil.retrieveDatasetUuidFromIdentifier((EsSearchManager)this.gc.getBean(EsSearchManager.class), datasetFeedInfo.identifier);
                String atomUrl = datasetFeedInfo.feedUrl;
                this.logger.info("Processing feed (" + i++ + "/" + total + ") for dataset metadata with uuid:" + metadataUuid + ", feed url: " + atomUrl);
                if (StringUtils.isEmpty((String)metadataUuid)) {
                    this.logger.warning("Metadata with dataset identifier (" + datasetFeedInfo.identifier + ") is not available. Skip dataset feed processing");
                    continue;
                }
                if (!atomUrl.toLowerCase().endsWith(".xml")) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for dataset metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                String metadataId = dataMan.getMetadataId(metadataUuid);
                this.logger.debug("Dataset, id=" + datasetFeedInfo.identifier + ", namespace=" + datasetFeedInfo.namespace);
                String atomFeedDocument = InspireAtomUtil.retrieveRemoteAtomFeedDocument(this.gc, atomUrl);
                this.logger.debug("Dataset feed: " + atomFeedDocument);
                Element atomDoc = Xml.loadString((String)atomFeedDocument, (boolean)false);
                if (!atomDoc.getNamespace().equals((Object)Geonet.Namespaces.ATOM)) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for dataset metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                InspireAtomFeed inspireAtomFeed = InspireAtomFeed.build((Element)atomDoc);
                inspireAtomFeed.setMetadataId(Integer.valueOf(Integer.parseInt(metadataId)));
                inspireAtomFeed.setAtomDatasetid(datasetFeedInfo.identifier);
                inspireAtomFeed.setAtomDatasetns(datasetFeedInfo.namespace);
                inspireAtomFeed.setAtomUrl(atomUrl);
                inspireAtomFeed.setAtom(atomFeedDocument);
                repository.save((Object)inspireAtomFeed);
                dataMan.indexMetadata(Arrays.asList(metadataId));
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("feed", atomUrl).setAttribute("status", "ok"));
            }
            catch (Exception ex) {
                this.logger.error("Failed to process atom feed for dataset metadata: " + metadataUuid + " " + ex.getMessage());
                this.logger.error((Throwable)ex);
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("error", ex.getMessage()).setAttribute("status", "error"));
            }
        }
    }
}

