/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.ResultSet;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.jzkit.search.util.ResultSet.IRResultSetStatus;

public class IRResultSetInfo
implements Serializable {
    public String name;
    public int total_fragment_count;
    public int status;
    public List record_sources;
    public String source_type;
    public String source_data;
    public String last_message;

    public IRResultSetInfo(String name, String source_type, String source_data, int total_fragment_count, int status, List record_sources) {
        this(name, source_type, source_data, total_fragment_count, status, record_sources, null);
    }

    public IRResultSetInfo(String name, String source_type, String source_data, int total_fragment_count, int status, List record_sources, String last_message) {
        this.name = name;
        this.total_fragment_count = total_fragment_count;
        this.status = status;
        this.record_sources = record_sources;
        this.source_type = source_type;
        this.source_data = source_data;
        this.last_message = last_message;
    }

    public IRResultSetInfo(String name, int total_fragment_count, int status, List record_sources) {
        this(name, "UNKNOWN", null, total_fragment_count, status, record_sources);
    }

    public IRResultSetInfo(String name, int total_fragment_count, int status) {
        this(name, "UNKNOWN", null, total_fragment_count, status, null);
    }

    public String getResultSetName() {
        return this.name;
    }

    public int getFragmentCount() {
        return this.total_fragment_count;
    }

    public int getStatus() {
        return this.status;
    }

    public List getSourceInfo() {
        return this.record_sources;
    }

    public String toString() {
        StringWriter result = new StringWriter();
        result.write("RS:" + this.name + ",Type:" + this.source_type + ",SrcInfo:" + this.source_data + ",Count:" + this.total_fragment_count + ",Status:" + IRResultSetStatus.getCode(this.status));
        if (this.record_sources != null) {
            result.write(" {\n");
            Iterator i = this.record_sources.iterator();
            while (i.hasNext()) {
                IRResultSetInfo child_info = (IRResultSetInfo)i.next();
                result.write(child_info.toString());
                if (!i.hasNext()) continue;
                result.write(",\n");
            }
            result.write("}");
        }
        return result.toString();
    }
}

