/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class RemoteCacheNoWait
implements AuxiliaryCache {
    private static final long serialVersionUID = -3104089136003714717L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait = RemoteCacheNoWait.class$("org.apache.jcs.auxiliary.remote.RemoteCacheNoWait")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait));
    private final IRemoteCacheClient cache;
    private ICacheEventQueue cacheEventQueue;
    private int getCount = 0;
    private int removeCount = 0;
    private int putCount = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait;

    public RemoteCacheNoWait(IRemoteCacheClient cache) {
        this.cache = cache;
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new CacheAdaptor(cache), cache.getListenerId(), cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
        if (cache.getStatus() == 3) {
            this.cacheEventQueue.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        ++this.putCount;
        try {
            this.cacheEventQueue.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding putEvent to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
            throw ex;
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        ++this.getCount;
        try {
            return this.cache.get(key);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrying the get owing to UnmarshalException...");
            }
            try {
                return this.cache.get(key);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failed in retrying the get for the second time. " + ex.getMessage()));
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return null;
    }

    public Set getGroupKeys(String groupName) throws IOException {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) throws IOException {
        ++this.removeCount;
        try {
            this.cacheEventQueue.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding RemoveEvent to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
            throw ex;
        }
        return false;
    }

    public void removeAll() throws IOException {
        try {
            this.cacheEventQueue.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding RemoveAllEvent to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
            throw ex;
        }
    }

    public void dispose() {
        try {
            this.cacheEventQueue.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)"Problem adding DisposeEvent to queue.", (Throwable)ex);
            this.cacheEventQueue.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return 4;
    }

    public int getStatus() {
        return this.cacheEventQueue.isWorking() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(IRemoteCacheService remote) {
        this.cache.fixCache(remote);
        this.resetEventQ();
    }

    public void resetEventQ() {
        ICacheEventQueue previousQueue = this.cacheEventQueue;
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new CacheAdaptor(this.cache), this.cache.getListenerId(), this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
        if (previousQueue.isWorking()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("resetEventQ, previous queue has [" + previousQueue.size() + "] items queued up."));
            }
            previousQueue.destroy();
        }
    }

    protected IRemoteCacheClient getRemoteCache() {
        return this.cache;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cache.getAuxiliaryCacheAttributes();
    }

    protected ICacheEventQueue getCacheEventQueue() {
        return this.cacheEventQueue;
    }

    public String toString() {
        return this.getStats() + "\n" + this.cache.toString();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Status");
        int status = this.getStatus();
        if (status == 3) {
            se.setData("ERROR");
        } else if (status == 1) {
            se.setData("ALIVE");
        } else if (status == 2) {
            se.setData("DISPOSED");
        } else {
            se.setData("" + status);
        }
        elems.add(se);
        IStats cStats = this.cache.getStatistics();
        if (cStats != null) {
            IStatElement[] cSEs = cStats.getStatElements();
            List<IStatElement> cL = Arrays.asList(cSEs);
            elems.addAll(cL);
        }
        IStats eqStats = this.cacheEventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Remove Count");
        se.setData("" + this.removeCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCount);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[elems.size()]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

