/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DomainType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.RequestMethodType;
import net.opengis.ows11.ValueType;
import net.opengis.wfs20.AbstractTransactionActionType;
import net.opengis.wfs20.DeleteType;
import net.opengis.wfs20.DescribeFeatureTypeType;
import net.opengis.wfs20.DescribeStoredQueriesType;
import net.opengis.wfs20.FeatureTypeListType;
import net.opengis.wfs20.FeatureTypeType;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.InsertType;
import net.opengis.wfs20.ListStoredQueriesType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.PropertyType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ResultTypeType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.StoredQueryType;
import net.opengis.wfs20.TransactionType;
import net.opengis.wfs20.UpdateType;
import net.opengis.wfs20.ValueReferenceType;
import net.opengis.wfs20.WFSCapabilitiesType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.DescribeStoredQueriesRequest;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.ListStoredQueriesRequest;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.TransactionRequest;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSExtensions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.data.wfs.internal.v2_0.Capabilities200ServiceInfo;
import org.geotools.data.wfs.internal.v2_0.FeatureTypeInfoImpl;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterTypeFactory;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.Configuration;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;

public class StrictWFS_2_0_Strategy
extends AbstractWFSStrategy {
    private static final List<String> PREFERRED_FORMATS = Collections.unmodifiableList(Arrays.asList("application/gml+xml; version=3.2", "text/xml; subtype=gml/3.2", "gml32", "text/xml; subtype=gml/3.1.1", "gml3", "text/xml; subtype=gml/2.1.2", "GML2"));
    private WFSCapabilitiesType capabilities;
    private final Map<QName, FeatureTypeType> typeInfos = new HashMap<QName, FeatureTypeType>();
    private static final Hints.ConfigurationMetadataKey CONFIG_KEY = Hints.ConfigurationMetadataKey.get((String)"WFS_NG_STORED_QUERY_CONFIGURATION");

    @Override
    public Configuration getFilterConfiguration() {
        return FILTER_2_0_CONFIGURATION;
    }

    @Override
    public Configuration getWfsConfiguration() {
        return WFS_2_0_CONFIGURATION;
    }

    @Override
    protected QName getOperationName(WFSOperationType operation) {
        return new QName("http://www.opengis.net/wfs/2.0", operation.getName());
    }

    @Override
    public void setCapabilities(WFSGetCapabilities capabilities) {
        WFSCapabilitiesType caps;
        this.capabilities = caps = (WFSCapabilitiesType)capabilities.getParsedCapabilities();
        this.typeInfos.clear();
        FeatureTypeListType featureTypeList = this.capabilities.getFeatureTypeList();
        EList featureTypes = featureTypeList.getFeatureType();
        for (FeatureTypeType typeInfo : featureTypes) {
            QName name = typeInfo.getName();
            this.typeInfos.put(name, typeInfo);
        }
    }

    @Override
    public WFSServiceInfo getServiceInfo() {
        URL getCapsUrl = this.getOperationURL(WFSOperationType.GET_CAPABILITIES, HttpMethod.GET);
        return new Capabilities200ServiceInfo("http://schemas.opengis.net/wfs/2.0/wfs.xsd", getCapsUrl, this.capabilities);
    }

    @Override
    public boolean supports(GetFeatureRequest.ResultType resultType) {
        switch (resultType) {
            case RESULTS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Version getServiceVersion() {
        return Versions.v2_0_0;
    }

    @Override
    public Set<QName> getFeatureTypeNames() {
        return new HashSet<QName>(this.typeInfos.keySet());
    }

    @Override
    public FeatureTypeInfo getFeatureTypeInfo(QName typeName) {
        FeatureTypeType eType = this.typeInfos.get(typeName);
        if (null == eType) {
            throw new IllegalArgumentException("Type name not found: " + typeName);
        }
        return new FeatureTypeInfoImpl(eType, this.config);
    }

    @Override
    public FilterCapabilities getFilterCapabilities() {
        return this.capabilities.getFilterCapabilities();
    }

    @Override
    protected Map<String, String> buildGetFeatureParametersForGET(GetFeatureRequest query) {
        Map<String, String> kvp = null;
        if (query.isStoredQuery()) {
            FeatureTypeInfoImpl featureTypeInfo = (FeatureTypeInfoImpl)this.getFeatureTypeInfo(query.getTypeName());
            StoredQueryDescriptionType desc = query.getStoredQueryDescriptionType();
            StoredQueryConfiguration config = null;
            kvp = new HashMap<String, String>();
            kvp.put("SERVICE", "WFS");
            kvp.put("VERSION", this.getVersion());
            kvp.put("REQUEST", "GetFeature");
            kvp.put("STOREDQUERY_ID", desc.getId());
            Filter originalFilter = query.getFilter();
            query.setUnsupportedFilter(originalFilter);
            this.updatePropertyNames(query, originalFilter);
            Map viewParams = null;
            if (query.getRequestHints() != null) {
                Map cast;
                viewParams = cast = (Map)query.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
                config = (StoredQueryConfiguration)query.getHints().get((Object)CONFIG_KEY);
            }
            List<ParameterType> params = new ParameterTypeFactory(config, desc, featureTypeInfo).buildStoredQueryParameters(viewParams, originalFilter);
            for (ParameterType p : params) {
                kvp.put(p.getName(), p.getValue());
            }
        } else {
            kvp = super.buildGetFeatureParametersForGET(query);
            if (query.getMaxFeatures() != null) {
                String count = kvp.remove("MAXFEATURES");
                kvp.put("COUNT", count);
            }
            String typeName = kvp.remove("TYPENAME");
            kvp.put("TYPENAMES", typeName);
        }
        return kvp;
    }

    @Override
    protected Map<String, String> buildDescribeFeatureTypeParametersForGET(Map<String, String> kvp, QName typeName) {
        String prefixedTypeName = this.getPrefixedTypeName(typeName);
        kvp.put("TYPENAMES", prefixedTypeName);
        if (!"".equals(typeName.getPrefix())) {
            String nsUri = typeName.getNamespaceURI();
            kvp.put("NAMESPACES", "xmlns(" + typeName.getPrefix() + "," + nsUri + ")");
        }
        return kvp;
    }

    @Override
    protected EObject createDescribeFeatureTypeRequestPost(DescribeFeatureTypeRequest request) {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        DescribeFeatureTypeType dft = factory.createDescribeFeatureTypeType();
        Version version = this.getServiceVersion();
        dft.setService("WFS");
        dft.setVersion(version.toString());
        dft.setHandle(request.getHandle());
        if (Versions.v1_0_0.equals((Object)version)) {
            dft.setOutputFormat(null);
        }
        QName typeName = request.getTypeName();
        EList typeNames = dft.getTypeName();
        typeNames.add(typeName);
        return dft;
    }

    @Override
    protected EObject createGetFeatureRequestPost(GetFeatureRequest query) throws IOException {
        StoredQueryType abstractQuery;
        GetFeatureRequest.ResultType resultType;
        QName typeName = query.getTypeName();
        FeatureTypeInfoImpl featureTypeInfo = (FeatureTypeInfoImpl)this.getFeatureTypeInfo(typeName);
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        GetFeatureType getFeature = factory.createGetFeatureType();
        getFeature.setService("WFS");
        getFeature.setVersion(this.getVersion());
        String outputFormat = query.getOutputFormat();
        getFeature.setOutputFormat(outputFormat);
        getFeature.setHandle(query.getHandle());
        Integer maxFeatures = query.getMaxFeatures();
        if (maxFeatures != null) {
            getFeature.setCount(BigInteger.valueOf(maxFeatures.intValue()));
        }
        getFeature.setResultType(GetFeatureRequest.ResultType.RESULTS == (resultType = query.getResultType()) ? ResultTypeType.RESULTS : ResultTypeType.HITS);
        if (query.isStoredQuery()) {
            StoredQueryDescriptionType desc = query.getStoredQueryDescriptionType();
            StoredQueryType storedQuery = factory.createStoredQueryType();
            storedQuery.setId(desc.getId());
            query.setUnsupportedFilter(query.getFilter());
            this.updatePropertyNames(query, query.getFilter());
            Map viewParams = null;
            StoredQueryConfiguration config = null;
            if (query.getRequestHints() != null) {
                Map cast;
                viewParams = cast = (Map)query.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
                config = (StoredQueryConfiguration)query.getHints().get((Object)CONFIG_KEY);
            }
            List<ParameterType> params = new ParameterTypeFactory(config, desc, featureTypeInfo).buildStoredQueryParameters(viewParams, query.getFilter());
            storedQuery.getParameter().addAll(params);
            abstractQuery = storedQuery;
        } else {
            boolean retrieveAllProperties;
            String srsName;
            QueryType wfsQuery = factory.createQueryType();
            wfsQuery.getTypeNames().add((Object)typeName);
            Filter filter = query.getFilter();
            Filter[] splitFilters = this.splitFilters(typeName, filter);
            Filter supportedFilter = splitFilters[0];
            Filter unsupportedFilter = splitFilters[1];
            query.setUnsupportedFilter(unsupportedFilter);
            this.updatePropertyNames(query, unsupportedFilter);
            if (!Filter.INCLUDE.equals(supportedFilter)) {
                wfsQuery.setFilter(supportedFilter);
            }
            if (null == (srsName = query.getSrsName())) {
                srsName = featureTypeInfo.getDefaultSRS();
            }
            try {
                wfsQuery.setSrsName(new URI(srsName));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Can't create a URI from the query CRS: " + srsName, e);
            }
            String[] propertyNames = query.getPropertyNames();
            boolean bl = retrieveAllProperties = propertyNames == null;
            if (!retrieveAllProperties) {
                EList propertyName = wfsQuery.getPropertyNames();
                for (String propName : propertyNames) {
                    propertyName.add(new QName(featureTypeInfo.getQName().getNamespaceURI(), propName));
                }
            }
            abstractQuery = wfsQuery;
        }
        getFeature.getAbstractQueryExpression().add((Object)abstractQuery);
        return getFeature;
    }

    @Override
    protected EObject createListStoredQueriesRequestPost(ListStoredQueriesRequest request) throws IOException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        ListStoredQueriesType ret = factory.createListStoredQueriesType();
        return ret;
    }

    @Override
    protected EObject createDescribeStoredQueriesRequestPost(DescribeStoredQueriesRequest request) throws IOException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        DescribeStoredQueriesType ret = factory.createDescribeStoredQueriesType();
        ret.getStoredQueryId().addAll(request.getStoredQueryIds());
        return ret;
    }

    @Override
    protected EObject createTransactionRequest(TransactionRequest request) throws IOException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        TransactionType tx = factory.createTransactionType();
        tx.setService("WFS");
        tx.setHandle(request.getHandle());
        tx.setVersion(this.getVersion());
        List<TransactionRequest.TransactionElement> transactionElements = request.getTransactionElements();
        if (transactionElements.isEmpty()) {
            Loggers.requestInfo("Asked to perform transaction with no transaction elements");
            return tx;
        }
        EList actions = tx.getAbstractTransactionAction();
        try {
            for (TransactionRequest.TransactionElement elem : transactionElements) {
                AbstractTransactionActionType action = null;
                if (elem instanceof TransactionRequest.Insert) {
                    action = this.createInsert(factory, (TransactionRequest.Insert)elem);
                } else if (elem instanceof TransactionRequest.Update) {
                    action = this.createUpdate(factory, (TransactionRequest.Update)elem);
                } else if (elem instanceof TransactionRequest.Delete) {
                    action = this.createDelete(factory, (TransactionRequest.Delete)elem);
                }
                actions.add(action);
            }
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception other) {
            throw new RuntimeException(other);
        }
        return tx;
    }

    @Override
    protected String getOperationURI(WFSOperationType operation, HttpMethod method) {
        OperationsMetadataType omt = this.capabilities.getOperationsMetadata();
        omt.getOperation();
        Loggers.trace(new Object[]{"Looking operation URI for ", operation, "/", method});
        EList operations = this.capabilities.getOperationsMetadata().getOperation();
        for (OperationType op : operations) {
            EList dcpTypes;
            if (!operation.getName().equals(op.getName()) || null == (dcpTypes = op.getDCP())) continue;
            for (DCPType d : dcpTypes) {
                List<RequestMethodType> methods = this.getMethods(method, d);
                if (null == methods || methods.isEmpty()) continue;
                String href = methods.get(0).getHref();
                Loggers.debug(new Object[]{"Returning operation URI for ", operation, "/", method, ": ", href});
                return href;
            }
        }
        Loggers.debug(new Object[]{"No operation URI found for ", operation, "/", method});
        return null;
    }

    private List<RequestMethodType> getMethods(HttpMethod method, DCPType d) {
        EList methods = HttpMethod.GET.equals((Object)method) ? d.getHTTP().getGet() : d.getHTTP().getPost();
        return methods;
    }

    @Override
    public Set<String> getServerSupportedOutputFormats(WFSOperationType operation) {
        String parameterName;
        switch (operation) {
            case GET_FEATURE: 
            case DESCRIBE_FEATURETYPE: 
            case GET_FEATURE_WITH_LOCK: {
                parameterName = "outputFormat";
                break;
            }
            case TRANSACTION: {
                parameterName = "inputFormat";
                break;
            }
            case LIST_STORED_QUERIES: 
            case DESCRIBE_STORED_QUERIES: {
                return Collections.singleton("text/xml");
            }
            default: {
                throw new UnsupportedOperationException("not yet implemented for " + (Object)((Object)operation));
            }
        }
        OperationType operationMetadata = this.getOperationMetadata(operation);
        Set<String> serverSupportedFormats = this.findParameters(operationMetadata, parameterName);
        if (serverSupportedFormats.isEmpty()) {
            serverSupportedFormats = this.findParameters(parameterName);
        }
        return serverSupportedFormats;
    }

    @Override
    public Set<String> getServerSupportedOutputFormats(QName typeName, WFSOperationType operation) {
        HashSet<String> ftypeFormats = new HashSet<String>();
        Set<String> serviceOutputFormats = this.getServerSupportedOutputFormats(operation);
        ftypeFormats.addAll(serviceOutputFormats);
        if (WFSOperationType.GET_FEATURE.equals((Object)operation)) {
            FeatureTypeInfo typeInfo = this.getFeatureTypeInfo(typeName);
            Set<String> typeAdvertisedFormats = typeInfo.getOutputFormats();
            ftypeFormats.addAll(typeAdvertisedFormats);
        }
        return ftypeFormats;
    }

    @Override
    public List<String> getClientSupportedOutputFormats(WFSOperationType operation) {
        List<WFSResponseFactory> operationResponseFactories = WFSExtensions.findResponseFactories(operation);
        LinkedList<String> outputFormats = new LinkedList<String>();
        for (WFSResponseFactory factory : operationResponseFactories) {
            List<String> factoryFormats = factory.getSupportedOutputFormats();
            outputFormats.addAll(factoryFormats);
        }
        if (WFSOperationType.GET_FEATURE.equals((Object)operation)) {
            for (String preferred : PREFERRED_FORMATS) {
                boolean hasFormat = outputFormats.remove(preferred);
                if (!hasFormat) continue;
                outputFormats.add(0, preferred);
                break;
            }
        }
        return outputFormats;
    }

    @Override
    public boolean supportsTransaction(QName typeName) {
        this.getFeatureTypeInfo(typeName);
        return this.supportsOperation(WFSOperationType.TRANSACTION, HttpMethod.POST);
    }

    protected OperationType getOperationMetadata(WFSOperationType operation) {
        OperationsMetadataType operationsMetadata = this.capabilities.getOperationsMetadata();
        EList operations = operationsMetadata.getOperation();
        String expectedOperationName = operation.getName();
        for (OperationType operationType : operations) {
            String operationName = operationType.getName();
            if (!expectedOperationName.equalsIgnoreCase(operationName)) continue;
            return operationType;
        }
        throw new NoSuchElementException("Operation metadata not found for " + expectedOperationName + " in the capabilities document");
    }

    @Override
    public Set<String> getSupportedCRSIdentifiers(QName typeName) {
        FeatureTypeInfo featureTypeInfo = this.getFeatureTypeInfo(typeName);
        String defaultSRS = featureTypeInfo.getDefaultSRS();
        List<String> otherSRS = featureTypeInfo.getOtherSRS();
        HashSet<String> ftypeCrss = new HashSet<String>();
        ftypeCrss.add(defaultSRS);
        ftypeCrss.addAll(otherSRS);
        boolean wfs2_0 = Versions.v2_0_0.equals((Object)this.getServiceVersion());
        if (wfs2_0) {
            OperationType operationMetadata = this.getOperationMetadata(WFSOperationType.GET_FEATURE);
            String operationParameter = "SrsName";
            Set<String> globalSrsNames = this.findParameters(operationMetadata, "SrsName");
            ftypeCrss.addAll(globalSrsNames);
        }
        return ftypeCrss;
    }

    private Set<String> findParameters(String parameterName) {
        OperationsMetadataType operationsMetadata = this.capabilities.getOperationsMetadata();
        EList parameters = operationsMetadata.getParameter();
        for (DomainType parameter : parameters) {
            if (!parameterName.equals(parameter.getName())) continue;
            HashSet<String> foundValues = new HashSet<String>();
            for (ValueType value : parameter.getAllowedValues().getValue()) {
                foundValues.add(value.getValue());
            }
            return foundValues;
        }
        return Collections.emptySet();
    }

    protected Set<String> findParameters(OperationType operationMetadata, String parameterName) {
        EList parameters = operationMetadata.getParameter();
        for (DomainType param : parameters) {
            String paramName = param.getName();
            if (!parameterName.equals(paramName)) continue;
            HashSet<String> foundValues = new HashSet<String>();
            for (ValueType value : param.getAllowedValues().getValue()) {
                foundValues.add(value.getValue());
            }
            return foundValues;
        }
        return Collections.emptySet();
    }

    protected AbstractTransactionActionType createInsert(Wfs20Factory factory, TransactionRequest.Insert elem) throws Exception {
        InsertType insert = factory.createInsertType();
        String srsName = this.getFeatureTypeInfo(elem.getTypeName()).getDefaultSRS();
        insert.setSrsName(srsName);
        List<SimpleFeature> features = elem.getFeatures();
        insert.getAny().addAll(features);
        return insert;
    }

    protected AbstractTransactionActionType createUpdate(Wfs20Factory factory, TransactionRequest.Update elem) throws Exception {
        List<QName> propertyNames = elem.getPropertyNames();
        List<Object> newValues = elem.getNewValues();
        if (propertyNames.size() != newValues.size()) {
            throw new IllegalArgumentException("Got " + propertyNames.size() + " property names and " + newValues.size() + " values");
        }
        UpdateType update = factory.createUpdateType();
        QName typeName = elem.getTypeName();
        update.setTypeName(typeName);
        String srsName = this.getFeatureTypeInfo(typeName).getDefaultSRS();
        update.setSrsName(srsName);
        Filter filter = elem.getFilter();
        update.setFilter(filter);
        EList properties = update.getProperty();
        for (int i = 0; i < propertyNames.size(); ++i) {
            QName propName = propertyNames.get(i);
            Object value = newValues.get(i);
            PropertyType property = factory.createPropertyType();
            ValueReferenceType ref = factory.createValueReferenceType();
            ref.setValue(propName);
            property.setValueReference(ref);
            property.setValue(value);
            properties.add(property);
        }
        return update;
    }

    protected AbstractTransactionActionType createDelete(Wfs20Factory factory, TransactionRequest.Delete elem) throws Exception {
        DeleteType delete = factory.createDeleteType();
        QName typeName = elem.getTypeName();
        delete.setTypeName(typeName);
        Filter filter = elem.getFilter();
        delete.setFilter(filter);
        return delete;
    }
}

