/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4.client;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Source;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponse;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponseDeserializer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class GeoNetwork4ApiClient {
    @Autowired
    private GeonetHttpRequestFactory requestFactory;
    @Autowired
    private SettingManager settingManager;

    public Map<String, Source> retrieveSources(String serverUrl, String user, String password) throws URISyntaxException, IOException {
        String sourcesJson = this.retrieveUrl(this.addUrlSlash(serverUrl) + "api/sources", user, password);
        ObjectMapper objectMapper = new ObjectMapper();
        List sourceList = (List)objectMapper.readValue(sourcesJson, (TypeReference)new TypeReference<List<Source>>(){});
        HashMap<String, Source> sourceMap = new HashMap<String, Source>();
        sourceList.forEach(s -> sourceMap.put(s.getUuid(), (Source)s));
        return sourceMap;
    }

    public List<Group> retrieveGroups(String serverUrl, String user, String password) throws URISyntaxException, IOException {
        String groupsJson = this.retrieveUrl(this.addUrlSlash(serverUrl) + "api/groups", user, password);
        ObjectMapper objectMapper = new ObjectMapper();
        return (List)objectMapper.readValue(groupsJson, (TypeReference)new TypeReference<List<Group>>(){});
    }

    public SearchResponse query(String serverUrl, String query, String user, String password) throws URISyntaxException, IOException {
        HttpPost httpMethod = new HttpPost(this.createUrl(this.addUrlSlash(serverUrl) + "api/search/records/_search"));
        BasicHeader headerContentType = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        BasicHeader header = new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        httpMethod.addHeader((Header)headerContentType);
        httpMethod.addHeader((Header)header);
        StringEntity entity = new StringEntity(query);
        httpMethod.setEntity((HttpEntity)entity);
        try (ClientHttpResponse httpResponse = this.doExecute((HttpUriRequest)httpMethod, user, password);){
            String jsonResponse = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleModule module = new SimpleModule("CustomSearchResponseDeserializer", new Version(1, 0, 0, null, null, null));
            module.addDeserializer(SearchResponse.class, (JsonDeserializer)new SearchResponseDeserializer());
            objectMapper.registerModule((Module)module);
            SearchResponse searchResponse = (SearchResponse)objectMapper.readValue(jsonResponse, SearchResponse.class);
            return searchResponse;
        }
    }

    public Path retrieveMEF(String serverUrl, String uuid, String user, String password) throws URISyntaxException, IOException {
        if (!Lib.net.isUrlValid(serverUrl)) {
            throw new BadParameterEx("Invalid URL", (Object)serverUrl);
        }
        Path tempFile = Files.createTempFile("temp-", ".dat", new FileAttribute[0]);
        String url = this.addUrlSlash(serverUrl) + "/api/records/" + uuid + "/formatters/zip?withRelated=false";
        HttpGet httpMethod = new HttpGet(this.createUrl(url));
        BasicHeader header = new BasicHeader("Accept", "application/x-gn-mef-2-zip");
        httpMethod.addHeader((Header)header);
        try (ClientHttpResponse httpResponse = this.doExecute((HttpUriRequest)httpMethod, user, password);){
            Files.copy(httpResponse.getBody(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFile;
    }

    private URI createUrl(String jsonUrl) throws URISyntaxException {
        return new URI(jsonUrl);
    }

    private String retrieveUrl(String serverUrl, String user, String password) throws URISyntaxException, IOException {
        if (!Lib.net.isUrlValid(serverUrl)) {
            throw new BadParameterEx("Invalid URL", (Object)serverUrl);
        }
        HttpGet httpMethod = new HttpGet(this.createUrl(serverUrl));
        BasicHeader header = new BasicHeader("Accept", ContentType.APPLICATION_JSON.toString());
        httpMethod.addHeader((Header)header);
        try (ClientHttpResponse httpResponse = this.doExecute((HttpUriRequest)httpMethod, user, password);){
            String string = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
            return string;
        }
    }

    private String addUrlSlash(String url) {
        return url + (!url.endsWith("/") ? "/" : "");
    }

    protected ClientHttpResponse doExecute(final HttpUriRequest method, final String username, final String password) throws IOException {
        final String requestHost = method.getURI().getHost();
        final HttpClientContext httpClientContext = HttpClientContext.create();
        Function<HttpClientBuilder, Void> requestConfiguration = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(HttpClientBuilder input) {
                if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                    HttpHost targetHost = new HttpHost(method.getURI().getHost(), method.getURI().getPort(), method.getURI().getScheme());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
                    RequestConfig.Builder builder = RequestConfig.custom();
                    builder.setAuthenticationEnabled(true);
                    builder.setRedirectsEnabled(true);
                    builder.setRelativeRedirectsAllowed(true);
                    builder.setCircularRedirectsAllowed(true);
                    builder.setMaxRedirects(3);
                    input.setDefaultRequestConfig(builder.build());
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    authCache.put(targetHost, (AuthScheme)basicAuth);
                    httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                    httpClientContext.setAuthCache((AuthCache)authCache);
                }
                Lib.net.setupProxy(GeoNetwork4ApiClient.this.settingManager, input, requestHost);
                input.useSystemProperties();
                return null;
            }
        };
        return this.requestFactory.execute(method, (Function)requestConfiguration, httpClientContext);
    }
}

