/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.Group;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeoNetworkAligner;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.GeonetParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.GeoNetwork4ApiClient;

public class Aligner
extends BaseGeoNetworkAligner<GeonetParams> {
    private final GeoNetwork4ApiClient geoNetwork4ApiClient;

    public Aligner(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, GeonetParams params, List<Group> groups) {
        super(cancelMonitor, log, context, params);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.geoNetwork4ApiClient = (GeoNetwork4ApiClient)gc.getBean(GeoNetwork4ApiClient.class);
        if (groups != null) {
            this.setupLocalGroup(groups, this.hmRemoteGroups);
        }
    }

    private void setupLocalGroup(List<Group> list, Map<String, Map<String, String>> hmEntity) {
        for (Group group : list) {
            String name = group.getName();
            HashMap hm = new HashMap();
            hmEntity.put(name, hm);
            hm.putAll(group.getLabelTranslations());
        }
    }

    @Override
    protected Path retrieveMEF(String uuid) throws URISyntaxException, IOException {
        String password;
        String username;
        if (((GeonetParams)this.params).isUseAccount()) {
            username = ((GeonetParams)this.params).getUsername();
            password = ((GeonetParams)this.params).getPassword();
        } else {
            username = "";
            password = "";
        }
        return this.geoNetwork4ApiClient.retrieveMEF(((GeonetParams)this.params).host + "/" + ((GeonetParams)this.params).getNode(), uuid, username, password);
    }
}

