/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.database;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.csw.Aligner;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterParams;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseMetadataRetriever;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseMetadataRetrieverFactory;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.util.StringUtils;

class DatabaseHarvesterAligner
extends BaseAligner<DatabaseHarvesterParams>
implements IHarvester<HarvestResult> {
    private Logger log;
    private final ServiceContext context;
    private final DataManager dataMan;
    private final IMetadataManager metadataManager;
    private final IMetadataUtils metadataUtils;
    private final IMetadataIndexer metadataIndexer;
    private final IMetadataSchemaUtils metadataSchemaUtils;
    private final MetadataRepository metadataRepository;
    private HarvestResult result;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private List<HarvestError> errors;
    private List<Integer> idsForHarvestingResult;
    private String processName;
    private Map<String, Object> processParams = new HashMap<String, Object>();

    public DatabaseHarvesterAligner(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, DatabaseHarvesterParams params, List<HarvestError> errors) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
        this.result = new HarvestResult();
        this.result.addedMetadata = 0;
        this.result.uuidSkipped = 0;
        this.result.datasetUuidExist = 0;
        this.result.couldNotInsert = 0;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.metadataSchemaUtils = (IMetadataSchemaUtils)gc.getBean(IMetadataSchemaUtils.class);
        this.metadataUtils = (IMetadataUtils)gc.getBean(IMetadataUtils.class);
        this.metadataIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.metadataRepository = (MetadataRepository)gc.getBean(MetadataRepository.class);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        if (log.isDebugEnabled()) {
            log.debug("Retrieving remote metadata information for : " + ((DatabaseHarvesterParams)this.params).getName());
        }
        DatabaseMetadataRetriever metadataRetriever = DatabaseMetadataRetrieverFactory.getDatabaseMetadataRetriever(((DatabaseHarvesterParams)this.params).getDatabaseType(), ((DatabaseHarvesterParams)this.params).getServer(), ((DatabaseHarvesterParams)this.params).getPort(), ((DatabaseHarvesterParams)this.params).getDatabase(), ((DatabaseHarvesterParams)this.params).getUsername(), ((DatabaseHarvesterParams)this.params).getPassword(), log);
        log.info("Start of alignment for : " + ((DatabaseHarvesterParams)this.params).getName());
        this.result = new HarvestResult();
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper(this.metadataUtils, ((DatabaseHarvesterParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((DatabaseHarvesterParams)this.params).getXslfilter());
        this.processName = (String)filter.one();
        this.processParams = (Map)filter.two();
        this.metadataManager.flush();
        this.idsForHarvestingResult = new ArrayList<Integer>();
        metadataRetriever.processMetadata(this.cancelMonitor, (DatabaseHarvesterParams)this.params, this);
        this.deleteLocalMetadataNotInDatabase(this.idsForHarvestingResult);
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void align(String metadata) {
        if (this.cancelMonitor.get()) {
            return;
        }
        try {
            ++this.result.totalMetadata;
            if (!StringUtils.hasLength((String)metadata)) {
                this.log.info("Processing empty metadata xml. Skipping");
                return;
            }
            Element metadataElement = Xml.loadString((String)metadata, (boolean)false);
            String id = this.processMetadata(metadataElement);
            if (StringUtils.hasLength((String)id)) {
                this.idsForHarvestingResult.add(Integer.valueOf(id));
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to process record from database (" + ((DatabaseHarvesterParams)this.params).getName() + ")");
            this.log.error("   Record failed. Error is: " + ex.getMessage());
            this.log.error((Throwable)ex);
            this.errors.add(new HarvestError(this.context, ex));
        }
        finally {
            ++this.result.originalMetadata;
        }
    }

    private void deleteLocalMetadataNotInDatabase(List<Integer> idsForHarvestingResult) throws Exception {
        HashSet idsResultHs = Sets.newHashSet(idsForHarvestingResult);
        List existingMetadata = this.metadataRepository.findIdsBy(MetadataSpecs.hasHarvesterUuid((String)((DatabaseHarvesterParams)this.params).getUuid()));
        for (Integer existingId : existingMetadata) {
            if (this.cancelMonitor.get()) {
                return;
            }
            if (idsResultHs.contains(existingId)) continue;
            this.log.debug("  Removing: " + existingId);
            this.metadataManager.deleteMetadata(this.context, existingId.toString());
            ++this.result.locallyRemoved;
        }
    }

    private String processMetadata(Element metadataElement) throws Exception {
        String id = "";
        String schema = this.getMetadataSchema(metadataElement);
        if (schema == null) {
            this.log.info("Skipping metadata with unknown schema.");
            ++this.result.unknownSchema;
            return id;
        }
        String uuid = this.metadataUtils.extractUUID(schema, metadataElement);
        if (!StringUtils.hasLength((String)uuid)) {
            this.log.info("No metadata uuid. Skipping.");
            ++this.result.badFormat;
            return id;
        }
        this.log.info(String.format("Processing metadata with UUID: %s", uuid));
        try {
            Integer groupIdVal = null;
            if (StringUtils.hasLength((String)((DatabaseHarvesterParams)this.params).getOwnerIdGroup())) {
                groupIdVal = Integer.parseInt(((DatabaseHarvesterParams)this.params).getOwnerIdGroup());
            }
            ((DatabaseHarvesterParams)this.params).getValidate().validate(this.dataMan, this.context, metadataElement, groupIdVal);
        }
        catch (Exception e) {
            this.log.error("Ignoring invalid metadata with uuid " + uuid);
            ++this.result.doesNotValidate;
            return id;
        }
        this.setParams(this.params);
        id = this.metadataUtils.getMetadataId(uuid);
        if (id == null) {
            id = this.addMetadata(metadataElement, uuid, schema);
            ++this.result.addedMetadata;
        } else if (this.localUuids.getID(uuid) == null) {
            ++this.result.datasetUuidExist;
            switch (((DatabaseHarvesterParams)this.params).getOverrideUuid()) {
                case OVERRIDE: {
                    this.updateMetadata(metadataElement, Integer.toString(this.metadataUtils.findOneByUuid(uuid).getId()), true);
                    this.log.debug(String.format("Overriding record with uuid %s", uuid));
                    ++this.result.updatedMetadata;
                    break;
                }
                case RANDOM: {
                    this.log.debug(String.format("Generating random uuid for remote record with uuid %s", uuid));
                    this.addMetadata(metadataElement, UUID.randomUUID().toString(), schema);
                    break;
                }
                case SKIP: {
                    this.log.debug(String.format("Skipping record with uuid %s", uuid));
                    ++this.result.uuidSkipped;
                    break;
                }
            }
        } else {
            this.updateMetadata(metadataElement, id, false);
            ++this.result.updatedMetadata;
        }
        return id;
    }

    private void updateMetadata(Element xml, String id, boolean force) throws Exception {
        String changeDate;
        this.log.info("Updating metadata with id: " + id);
        boolean validate = false;
        boolean ufo = false;
        String language = this.context.getLanguage();
        String schema = this.metadataSchemaUtils.autodetectSchema(xml);
        String uuid = this.metadataUtils.extractUUID(schema, xml);
        try {
            changeDate = this.metadataUtils.extractDateModified(schema, xml);
        }
        catch (Exception ex) {
            this.log.error("Database harvester - updateMetadata - can't get metadata modified date for metadata id= " + id + ", using current date for modified date");
            changeDate = new ISODate().toString();
        }
        boolean updateSchema = false;
        if (StringUtils.hasLength((String)((DatabaseHarvesterParams)this.params).getXslfilter())) {
            String newSchema = this.metadataSchemaUtils.autodetectSchema(xml = this.applyXSLTProcessToMetadata(this.context, xml, this.processName, this.processParams, this.log));
            updateSchema = newSchema != null && !newSchema.equals(schema);
            schema = newSchema;
        }
        Aligner.applyBatchEdits(uuid, xml, schema, ((DatabaseHarvesterParams)this.params).getBatchEdits(), this.context, this.log);
        if (((DatabaseHarvesterParams)this.params).isTranslateContent()) {
            xml = this.translateMetadataContent(this.context, xml, schema);
        }
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, xml, validate, ufo, language, changeDate, true, IndexingMode.none);
        if (force || updateSchema) {
            if (force) {
                metadata.getHarvestInfo().setUuid(((DatabaseHarvesterParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((DatabaseHarvesterParams)this.params).getUuid());
            }
            if (updateSchema) {
                metadata.getDataInfo().setSchemaId(schema);
            }
            this.metadataManager.save(metadata);
        }
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
        operationAllowedRepository.deleteAllByMetadataId(Integer.parseInt(id));
        this.addPrivileges(id, ((DatabaseHarvesterParams)this.params).getPrivileges(), this.localGroups, this.context);
        metadata.getCategories().clear();
        this.addCategories(metadata, ((DatabaseHarvesterParams)this.params).getCategories(), this.localCateg, this.context, null, true);
        this.metadataManager.flush();
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
    }

    private String addMetadata(Element xml, String uuid, String schema) throws Exception {
        ISODate createDate;
        boolean newMdUuidFromXslt;
        this.log.info("  - Adding metadata with remote uuid: " + uuid);
        String newMdUuid = null;
        if (StringUtils.hasLength((String)((DatabaseHarvesterParams)this.params).getXslfilter())) {
            xml = this.applyXSLTProcessToMetadata(this.context, xml, this.processName, this.processParams, this.log);
            schema = this.metadataSchemaUtils.autodetectSchema(xml);
            newMdUuid = this.metadataUtils.extractUUID(schema, xml);
        }
        if (!(newMdUuidFromXslt = StringUtils.hasLength(newMdUuid))) {
            Aligner.applyBatchEdits(uuid, xml, schema, ((DatabaseHarvesterParams)this.params).getBatchEdits(), this.context, this.log);
        } else {
            Aligner.applyBatchEdits(newMdUuid, xml, schema, ((DatabaseHarvesterParams)this.params).getBatchEdits(), this.context, this.log);
        }
        if (((DatabaseHarvesterParams)this.params).isTranslateContent()) {
            xml = this.translateMetadataContent(this.context, xml, schema);
        }
        try {
            createDate = new ISODate(this.metadataUtils.extractDateModified(schema, xml));
        }
        catch (Exception ex) {
            this.log.error("Database harvester - addMetadata - can't get metadata modified date for metadata with uuid= " + uuid + ", using current date for modified date");
            createDate = new ISODate();
        }
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(xml.getQualifiedName()).setType(MetadataType.METADATA).setCreateDate(createDate).setChangeDate(createDate);
        metadata.getSourceInfo().setSourceId(((DatabaseHarvesterParams)this.params).getUuid()).setOwner(Integer.valueOf(Integer.parseInt(((DatabaseHarvesterParams)this.params).getOwnerId()))).setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((DatabaseHarvesterParams)this.params).getUuid());
        this.addCategories((AbstractMetadata)metadata, ((DatabaseHarvesterParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, xml, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((DatabaseHarvesterParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
        return id;
    }

    private String getMetadataSchema(Element metadataElement) {
        try {
            return this.metadataSchemaUtils.autodetectSchema(metadataElement, null);
        }
        catch (NoSchemaMatchesException ex) {
            return null;
        }
    }
}

