/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.database;

import java.sql.SQLException;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterAligner;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterParams;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterUtil;

public class DatabaseHarvester
extends AbstractHarvester<HarvestResult, DatabaseHarvesterParams> {
    @Override
    protected DatabaseHarvesterParams createParams() {
        return new DatabaseHarvesterParams(this.dataMan);
    }

    @Override
    protected void storeNodeExtra(DatabaseHarvesterParams params, String path, String siteId, String optionsId) throws SQLException {
        params.setTableName(DatabaseHarvesterUtil.sanitizeTableName(params.getTableName()));
        params.setMetadataField(DatabaseHarvesterUtil.sanitizeFieldName(params.getMetadataField()));
        params.setFilterField(DatabaseHarvesterUtil.sanitizeFieldName(params.getFilterField()));
        this.setParams(params);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"icon", (Object)params.getIcon());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"server", (Object)params.getServer());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"port", (Object)params.getPort());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"username", (Object)params.getUsername());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"password", (Object)params.getPassword());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"database", (Object)params.getDatabase());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"databaseType", (Object)params.getDatabaseType());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"tableName", (Object)params.getTableName());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"metadataField", (Object)params.getMetadataField());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"xslfilter", (Object)params.getXslfilter());
        String filtersID = this.harvesterSettingsManager.add(path, (Object)"filter", (Object)"");
        this.harvesterSettingsManager.add("id:" + filtersID, (Object)"field", (Object)params.getFilterField());
        this.harvesterSettingsManager.add("id:" + filtersID, (Object)"value", (Object)params.getFilterValue());
        this.harvesterSettingsManager.add("id:" + filtersID, (Object)"operator", (Object)params.getFilterOperator());
    }

    @Override
    protected void doHarvest(Logger l) throws Exception {
        this.log.info("Database harvester start");
        DatabaseHarvesterAligner h = new DatabaseHarvesterAligner(this.cancelMonitor, this.log, this.context, (DatabaseHarvesterParams)this.params, this.errors);
        this.result = h.harvest(this.log);
        this.log.info("Database harvester end");
    }
}

