/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms.map;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridReaderLayer;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSCoverageReader;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMSLayer
extends GridReaderLayer {
    static Style STYLE;

    public WMSLayer(WebMapServer wms, Layer layer) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer), STYLE);
    }

    public WMSLayer(WebMapServer wms, Layer layer, String style) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer, style), STYLE);
    }

    public WMSLayer(WebMapServer wms, Layer layer, String style, String imageFromat) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer, style, imageFromat), STYLE);
    }

    public WMSCoverageReader getReader() {
        return (WMSCoverageReader)this.reader;
    }

    public synchronized ReferencedEnvelope getBounds() {
        WMSCoverageReader wmsReader = this.getReader();
        if (wmsReader != null) {
            return wmsReader.bounds;
        }
        return super.getBounds();
    }

    /*
     * Exception decompiling
     */
    public String getFeatureInfoAsText(DirectPosition2D pos, int featureCount) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getFeatureInfo(DirectPosition2D pos, String infoFormat, int featureCount) throws IOException {
        GetMapRequest mapRequest = this.getReader().mapRequest;
        return this.getReader().getFeatureInfo(pos, infoFormat, featureCount, mapRequest);
    }

    public InputStream getFeatureInfo(ReferencedEnvelope bbox, int width, int height, int x, int y, String infoFormat, int featureCount) throws IOException {
        try {
            this.getReader().initMapRequest(bbox, width, height, null);
            AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)bbox, (Rectangle)new Rectangle(width, height));
            Point2D.Double screenPos = new Point2D.Double(x, y);
            Point2D.Double worldPos = new Point2D.Double(x, y);
            at.inverseTransform(screenPos, worldPos);
            DirectPosition2D fromPos = new DirectPosition2D(((Point2D)worldPos).getX(), ((Point2D)worldPos).getY());
            DirectPosition2D toPos = new DirectPosition2D();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.getReader().requestedEnvelope.getCoordinateReferenceSystem(), (boolean)true);
            mt.transform((DirectPosition)fromPos, (DirectPosition)toPos);
            GetMapRequest mapRequest = this.getLastGetMap();
            return this.getReader().getFeatureInfo(toPos, infoFormat, featureCount, mapRequest);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Unexpected issue during GetFeatureInfo execution").initCause(t);
        }
    }

    public WebMapServer getWebMapServer() {
        return this.getReader().wms;
    }

    public List<Layer> getWMSLayers() {
        return ((WMSCoverageReader)this.reader).getLayers();
    }

    public List<String> getWMSStyles() {
        return ((WMSCoverageReader)this.reader).getStyles();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.reader.getCoordinateReferenceSystem();
    }

    public GetMapRequest getLastGetMap() {
        return this.getReader().mapRequest;
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, "");
    }

    public void addLayer(Layer layer, String style) {
        this.getReader().addLayer(layer, style);
    }

    public boolean isNativelySupported(CoordinateReferenceSystem crs) {
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            return code != null && this.getReader().validSRS.contains(code);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer symbolizer = factory.createRasterSymbolizer();
        Rule rule = factory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle type = factory.createFeatureTypeStyle();
        type.rules().add(rule);
        STYLE = factory.createStyle();
        STYLE.featureTypeStyles().add(type);
    }
}

