/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;

public final class DataManagerFacade
implements DataManager {
    private static final ByteSequence FORCE_COMMAND = new ByteSequence(new byte[]{70, 79, 82, 67, 69});
    private AsyncDataManager dataManager;
    private final String name;
    private Marshaller redoMarshaller;

    public DataManagerFacade(AsyncDataManager dataManager, String name) {
        this.dataManager = dataManager;
        this.name = name;
    }

    private static StoreLocation convertToStoreLocation(Location location) {
        if (location == null) {
            return null;
        }
        return new StoreLocationFacade(location);
    }

    private static Location convertFromStoreLocation(StoreLocation location) {
        if (location == null) {
            return null;
        }
        if (location.getClass() == StoreLocationFacade.class) {
            return ((StoreLocationFacade)location).getLocation();
        }
        Location l = new Location();
        l.setOffset((int)location.getOffset());
        l.setSize(location.getSize());
        l.setDataFileId(location.getFile());
        return l;
    }

    @Override
    public Object readItem(Marshaller marshaller, StoreLocation location) throws IOException {
        ByteSequence sequence = this.dataManager.read(DataManagerFacade.convertFromStoreLocation(location));
        DataByteArrayInputStream dataIn = new DataByteArrayInputStream(sequence);
        return marshaller.readPayload(dataIn);
    }

    @Override
    public StoreLocation storeDataItem(Marshaller marshaller, Object payload) throws IOException {
        DataByteArrayOutputStream buffer = new DataByteArrayOutputStream();
        marshaller.writePayload(payload, buffer);
        ByteSequence data = buffer.toByteSequence();
        return DataManagerFacade.convertToStoreLocation(this.dataManager.write(data, (byte)1, false));
    }

    @Override
    public void force() throws IOException {
        this.dataManager.write(FORCE_COMMAND, (byte)2, true);
    }

    @Override
    public void updateItem(StoreLocation location, Marshaller marshaller, Object payload) throws IOException {
        DataByteArrayOutputStream buffer = new DataByteArrayOutputStream();
        marshaller.writePayload(payload, buffer);
        ByteSequence data = buffer.toByteSequence();
        this.dataManager.update(DataManagerFacade.convertFromStoreLocation(location), data, false);
    }

    @Override
    public void close() throws IOException {
        this.dataManager.close();
    }

    @Override
    public void consolidateDataFiles() throws IOException {
        this.dataManager.consolidateDataFiles();
    }

    @Override
    public boolean delete() throws IOException {
        return this.dataManager.delete();
    }

    @Override
    public void addInterestInFile(int file) throws IOException {
        this.dataManager.addInterestInFile(file);
    }

    @Override
    public void removeInterestInFile(int file) throws IOException {
        this.dataManager.removeInterestInFile(file);
    }

    @Override
    public void recoverRedoItems(RedoListener listener) throws IOException {
        throw new RuntimeException("Not Implemented..");
    }

    @Override
    public StoreLocation storeRedoItem(Object payload) throws IOException {
        throw new RuntimeException("Not Implemented..");
    }

    @Override
    public Marshaller getRedoMarshaller() {
        return this.redoMarshaller;
    }

    @Override
    public void setRedoMarshaller(Marshaller redoMarshaller) {
        this.redoMarshaller = redoMarshaller;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class StoreLocationFacade
    implements StoreLocation {
        private final Location location;

        public StoreLocationFacade(Location location) {
            this.location = location;
        }

        @Override
        public int getFile() {
            return this.location.getDataFileId();
        }

        @Override
        public long getOffset() {
            return this.location.getOffset();
        }

        @Override
        public int getSize() {
            return this.location.getSize();
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

