/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.fao.geonet.ApplicationContextHolder;
import org.jdom.Element;

public class SystemInfo {
    public static final String STAGE_TESTING = Staging.testing.toString();
    public static final String STAGE_DEVELOPMENT = Staging.development.toString();
    public static final String STAGE_PRODUCTION = Staging.production.toString();
    private String stagingProfile = STAGE_PRODUCTION;
    private String buildDate;
    private String version;
    private String subVersion;
    private String buildOsInfo;
    private String buildJavaVersion;
    private String buildJavaVendor;
    private String scmUrl;
    private String scmRevision;

    public static SystemInfo createForTesting(String stagingProfile) {
        String version = "3.0.0";
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("version.properties");){
            Properties p = new Properties();
            p.load(stream);
            version = p.getProperty("version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new SystemInfo(stagingProfile, "testing", version, "SNAPSHOT", "testing", "testing", "testing", "", "");
    }

    public SystemInfo(String stagingProfile, String buildDate, String version, String subVersion, String buildOsInfo, String buildJavaVersion, String buildJavaVendor, String scmUrl, String scmRevision) {
        this.stagingProfile = stagingProfile;
        this.buildDate = buildDate;
        this.version = version;
        this.subVersion = subVersion;
        this.buildOsInfo = buildOsInfo;
        this.buildJavaVersion = buildJavaVersion;
        this.buildJavaVendor = buildJavaVendor;
        this.scmUrl = scmUrl;
        this.scmRevision = scmRevision;
    }

    public static SystemInfo getInfo() {
        return SystemInfo.getInfo(null);
    }

    public String getStagingProfile() {
        return this.stagingProfile;
    }

    public void setStagingProfile(String stagingProfile) {
        this.stagingProfile = stagingProfile;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getSubVersion() {
        return this.subVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildOsInfo() {
        return this.buildOsInfo;
    }

    public String getBuildJavaVersion() {
        return this.buildJavaVersion;
    }

    public String getBuildJavaVendor() {
        return this.buildJavaVendor;
    }

    public boolean isDevMode() {
        return STAGE_DEVELOPMENT.equals(this.stagingProfile) || STAGE_TESTING.equals(this.stagingProfile);
    }

    public Element toXml() {
        return new Element("systemInfo").addContent(Arrays.asList(new Element("stagingProfile").setText(this.stagingProfile), new Element("buildOsInfo").setText(this.buildOsInfo), new Element("buildJavaVendor").setText(this.buildJavaVendor), new Element("buildJavaVersion").setText(this.buildJavaVersion), new Element("buildDate").setText(this.buildDate), new Element("scmRevision").setText(this.scmRevision)));
    }

    public static SystemInfo getInfo(SystemInfo defaultInfo) {
        SystemInfo actualInfo = defaultInfo;
        if (actualInfo == null && ApplicationContextHolder.get() != null) {
            actualInfo = (SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class);
        }
        return actualInfo;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public static enum Staging {
        testing,
        development,
        production;

    }
}

