/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.impl;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ScaleZoomLevelMatcher {
    private CoordinateReferenceSystem crsMap;
    private CoordinateReferenceSystem crsTiles;
    private MathTransform transformMapToTileCrs;
    private MathTransform transformTileCrsToMap;
    private ReferencedEnvelope mapExtentTileCrs;
    private double scale;
    private static double DPI;

    public ScaleZoomLevelMatcher(CoordinateReferenceSystem crsMap, CoordinateReferenceSystem crsTiles, MathTransform transformMapToTileCrs, MathTransform transformTileCrsToMap, ReferencedEnvelope mapExtentTileCrs, ReferencedEnvelope mapExtentMapCrs, double scale) {
        this.crsMap = crsMap;
        this.crsTiles = crsTiles;
        this.transformMapToTileCrs = transformMapToTileCrs;
        this.transformTileCrsToMap = transformTileCrsToMap;
        this.mapExtentTileCrs = mapExtentTileCrs;
        this.scale = scale;
    }

    public static ScaleZoomLevelMatcher createMatcher(ReferencedEnvelope requestExtent, CoordinateReferenceSystem crsTiles, double scale) throws FactoryException, TransformException {
        CoordinateReferenceSystem crsMap = requestExtent.getCoordinateReferenceSystem();
        MathTransform transformMapToTile = CRS.findMathTransform(crsMap, crsTiles);
        MathTransform transformTileToMap = CRS.findMathTransform(crsTiles, crsMap);
        ReferencedEnvelope mapExtentTileCrs = ScaleZoomLevelMatcher.getProjectedEnvelope(requestExtent, crsTiles, transformMapToTile);
        return new ScaleZoomLevelMatcher(crsMap, crsTiles, transformMapToTile, transformTileToMap, mapExtentTileCrs, requestExtent, scale);
    }

    public static ReferencedEnvelope getProjectedEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem destinationCRS, MathTransform transformation) throws TransformException, FactoryException {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (sourceCRS.equals(destinationCRS)) {
            return envelope;
        }
        try {
            return new ReferencedEnvelope(JTS.transform(envelope, transformation), destinationCRS);
        }
        catch (Exception exc) {
            return envelope.transform(destinationCRS, false);
        }
    }

    public CoordinateReferenceSystem getCrsMap() {
        return this.crsMap;
    }

    public CoordinateReferenceSystem getCrsTiles() {
        return this.crsTiles;
    }

    public ReferencedEnvelope getMapExtentTileCrs() {
        return this.mapExtentTileCrs;
    }

    public double getScale() {
        return this.scale;
    }

    public int getZoomLevelFromScale(TileService service, double[] tempScaleList) {
        double[] scaleList = service.getScaleList();
        int zoomLevel = scaleList.length - 1;
        this.getOptimumScaleFromZoomLevel(zoomLevel, service, tempScaleList);
        for (int i = scaleList.length - 2; i >= 0 && !Double.isNaN(scaleList[i]) && !(this.getScale() < this.getOptimumScaleFromZoomLevel(i, service, tempScaleList)); --i) {
            zoomLevel = i;
            if (!(this.getScale() > this.getOptimumScaleFromZoomLevel(i + 1, service, tempScaleList))) continue;
            zoomLevel = i;
        }
        return zoomLevel;
    }

    public double getOptimumScaleFromZoomLevel(int zoomLevel, TileService service, double[] tempScaleList) {
        if (!Double.isNaN(tempScaleList[zoomLevel])) {
            return tempScaleList[zoomLevel];
        }
        try {
            double _scale;
            ReferencedEnvelope centerTileBounds = this.getBoundsOfCenterTileInMapCrs(zoomLevel, service);
            tempScaleList[zoomLevel] = _scale = RendererUtilities.calculateScale((ReferencedEnvelope)centerTileBounds, (int)service.getTileWidth(), (int)service.getTileHeight(), (double)DPI);
            return _scale;
        }
        catch (Exception exc) {
            Logger.getGlobal().log(Level.INFO, "", exc);
            return service.getScaleList()[zoomLevel];
        }
    }

    public double getOptimumScaleFromZoomLevel(int zoomLevel, TileService wmtSource) {
        double[] tempScaleList = new double[wmtSource.getScaleList().length];
        Arrays.fill(tempScaleList, Double.NaN);
        return this.getOptimumScaleFromZoomLevel(zoomLevel, wmtSource, tempScaleList);
    }

    private ReferencedEnvelope getBoundsOfCenterTileInMapCrs(int zoomLevel, TileService wmtSource) throws Exception {
        Tile centerTile = this.getCenterTile(zoomLevel, wmtSource);
        ReferencedEnvelope boundsInTileCrs = centerTile.getExtent();
        ReferencedEnvelope boundsInMapCrs = this.projectTileToMapCrs(boundsInTileCrs);
        return boundsInMapCrs;
    }

    private Tile getCenterTile(int zoomLevel, TileService wmtSource) {
        TileFactory tileFactory = wmtSource.getTileFactory();
        ZoomLevel zoomLevelInstance = tileFactory.getZoomLevel(zoomLevel, wmtSource);
        Coordinate centerPoint = this.mapExtentTileCrs.centre();
        return tileFactory.findTileAtCoordinate(centerPoint.x, centerPoint.y, zoomLevelInstance, wmtSource);
    }

    public ReferencedEnvelope projectTileToMapCrs(ReferencedEnvelope boundsInTileCrs) throws Exception {
        return ScaleZoomLevelMatcher.getProjectedEnvelope(boundsInTileCrs, this.crsMap, this.transformTileCrsToMap);
    }

    public ReferencedEnvelope projectMapToTileCrs(ReferencedEnvelope boundsInMapCrs) throws Exception {
        return ScaleZoomLevelMatcher.getProjectedEnvelope(boundsInMapCrs, this.crsTiles, this.transformMapToTileCrs);
    }

    static {
        try {
            DPI = 96.0;
        }
        catch (Exception exc) {
            DPI = 96.0;
        }
    }
}

