/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.uisetting;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UiSetting;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UiSettingsRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/ui"})
@Tag(name="ui", description="User interface configuration operations")
@Controller(value="ui")
public class UiSettingApi {
    @Autowired
    UiSettingsRepository uiSettingsRepository;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    UserGroupRepository userGroupRepository;

    @Operation(summary="Get UI configuration", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of configuration.")})
    @ResponseBody
    public List<UiSetting> getUiConfigurations() throws Exception {
        return this.uiSettingsRepository.findAll();
    }

    @Operation(summary="Create a UI configuration", description="")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="UI configuration created. Return the new UI configuration identifier."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity<String> putUiConfiguration(@Parameter(name="uiConfiguration") @RequestBody UiSetting uiConfiguration) throws Exception {
        if (StringUtils.isEmpty((String)uiConfiguration.getId())) {
            throw new IllegalArgumentException(String.format("A UI configuration MUST have an id. The id could be a string to easily identify the configuration.", uiConfiguration.getId()));
        }
        Optional one = this.uiSettingsRepository.findById((Object)uiConfiguration.getId());
        if (one.isPresent()) {
            throw new IllegalArgumentException(String.format("A UI configuration with id '%d' already exist", uiConfiguration.getId()));
        }
        UiSetting save = (UiSetting)this.uiSettingsRepository.save((Object)uiConfiguration);
        return new ResponseEntity((Object)save.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Get a UI configuration", description="")
    @RequestMapping(value={"/{uiIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="UI configuration.")})
    @ResponseBody
    public UiSetting getUiConfiguration(@Parameter(description="UI identifier", required=true) @PathVariable String uiIdentifier) throws Exception {
        Optional uiConfiguration = this.uiSettingsRepository.findById((Object)uiIdentifier);
        if (!uiConfiguration.isPresent()) {
            throw new ResourceNotFoundException(String.format("UI configuration with id '%s' does not exist.", uiIdentifier));
        }
        return (UiSetting)uiConfiguration.get();
    }

    @Operation(summary="Update a UI configuration", description="")
    @RequestMapping(value={"/{uiIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="UI configuration updated."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity updateUiConfiguration(@Parameter(description="UI configuration identifier", required=true) @PathVariable String uiIdentifier, @Parameter(name="UI configuration") @RequestBody UiSetting uiConfiguration, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Optional one = this.uiSettingsRepository.findById((Object)uiIdentifier);
        if (one.isPresent()) {
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean isUserAdmin = session.getProfile().equals((Object)Profile.UserAdmin);
            if (isUserAdmin) {
                if (this.canManageUISettings(uiIdentifier, session)) {
                    this.uiSettingsRepository.save((Object)uiConfiguration);
                    return new ResponseEntity(HttpStatus.NO_CONTENT);
                }
                throw new NotAllowedException(String.format("UI configuration with id '%s' is not used in any portal managed by current user. You are not allowed to update this configuration.", uiIdentifier));
            }
        } else {
            throw new ResourceNotFoundException(String.format("UI configuration with id '%s' does not exist.", uiIdentifier));
        }
        this.uiSettingsRepository.save((Object)uiConfiguration);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(summary="Remove a UI Configuration", description="")
    @RequestMapping(value={"/{uiIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="UI Configuration removed."), @ApiResponse(responseCode="404", description="UI Configuration not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    public ResponseEntity deleteUiConfiguration(@Parameter(description="UI configuration identifier", required=true) @PathVariable String uiIdentifier, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        Optional one = this.uiSettingsRepository.findById((Object)uiIdentifier);
        if (one.isPresent()) {
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean isUserAdmin = session.getProfile().equals((Object)Profile.UserAdmin);
            if (isUserAdmin) {
                if (this.canManageUISettings(uiIdentifier, session)) {
                    this.uiSettingsRepository.deleteById((Object)uiIdentifier);
                    return new ResponseEntity(HttpStatus.NO_CONTENT);
                }
                throw new NotAllowedException(String.format("UI configuration with id '%s' is not used in any portal managed by current user. You are not allowed to update this configuration.", uiIdentifier));
            }
        } else {
            throw new ResourceNotFoundException(String.format("UI Configuration with id '%s' does not exist.", uiIdentifier));
        }
        this.uiSettingsRepository.deleteById((Object)uiIdentifier);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private boolean canManageUISettings(String uiIdentifier, UserSession session) {
        Specification spec = Specification.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        spec = spec.and(UserGroupSpecs.hasProfile((Profile)Profile.UserAdmin));
        HashSet ids = new HashSet(this.userGroupRepository.findGroupIds(spec));
        List sources = this.sourceRepository.findByGroupOwnerIn(ids);
        boolean isUiConfigForOneOfUserPortal = sources.stream().anyMatch(source -> uiIdentifier.equals(source.getUiConfig()));
        return isUiConfigForOneOfUserPortal;
    }
}

