/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.mapservers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.fao.geonet.api.exception.GeoPublisherException;
import org.fao.geonet.api.mapservers.GeoFile;
import org.fao.geonet.api.mapservers.GeoServerRest;
import org.fao.geonet.utils.Log;

public class MapServersUtils {
    public static final String MODULE = "geonetwork.geoserver.publisher";

    public static String publishDbTable(ACTION action, GeoServerRest g, String string, String host, String port, String user, String password, String db, String table, String dbType, String ns, String metadataUuid, String metadataTitle, String metadataAbstract) throws GeoPublisherException, IOException {
        if (action == ACTION.CREATE || action == ACTION.UPDATE) {
            StringBuilder report = new StringBuilder();
            if (!g.createDatabaseDatastore(db, host, port, db, user, password, dbType, ns)) {
                report.append("Datastore: ").append(g.getStatus());
            }
            if (!g.createFeatureType(db, table, metadataUuid, metadataTitle, metadataAbstract)) {
                report.append("Feature type: ").append(g.getStatus());
            }
            if (!g.createStyle(db, table)) {
                report.append("Style: ").append(g.getStatus());
            }
        } else if (action == ACTION.DELETE) {
            StringBuilder report = new StringBuilder();
            if (!g.deleteLayer(table)) {
                report.append("Layer: ").append(g.getStatus());
            }
            if (report.length() > 0) {
                throw new GeoPublisherException(String.format("Failed to unpublish database table. Status '%d', error is %s", g.getStatus(), g.getResponse()));
            }
        }
        if (g.getLayer(table)) {
            return String.format("Database table '%s' is published in the mapserver", table);
        }
        throw new GeoPublisherException(String.format("Database table not found. Status '%d'.", g.getStatus(), g.getResponse()));
    }

    public static String addZipFile(ACTION action, GeoServerRest gs, Path f, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException, GeoPublisherException {
        Collection<String> rasterLayers;
        Collection<String> vectorLayers;
        block33: {
            if (f == null) {
                throw new GeoPublisherException(String.format("File is null. Check parameters.", new Object[0]));
            }
            try (GeoFile gf = new GeoFile(f);){
                block34: {
                    block35: {
                        block36: {
                            vectorLayers = gf.getVectorLayers(true);
                            if (vectorLayers.size() <= 0) break block36;
                            if (MapServersUtils.publishVector(f, gf, gs, action, metadataUuid, metadataTitle, metadataAbstract)) {
                                if (action == ACTION.DELETE) {
                                    String string = gs.getReport();
                                    return string;
                                }
                                String string = String.format("Vector layer '%s' is published in the mapserver.", f);
                                return string;
                            }
                            try {
                                throw new GeoPublisherException(String.format("%s %s", gs.getReport(), gs.getErrorCode()));
                            }
                            catch (IllegalArgumentException e) {
                                throw new GeoPublisherException(String.format("Failed to publish vector file '%s'. Error is %s", f, e.getMessage()));
                            }
                        }
                        try {
                            rasterLayers = gf.getRasterLayers();
                            if (rasterLayers.size() <= 0) break block33;
                            if (!MapServersUtils.publishRaster(f, gs, action, metadataUuid, metadataTitle, metadataAbstract)) break block34;
                            if (action != ACTION.DELETE) break block35;
                            String e = gs.getReport();
                            return e;
                        }
                        catch (IllegalArgumentException e) {
                            throw new GeoPublisherException(String.format("Failed to publish raster file '%s'. Error is %s", f, e.getMessage()));
                        }
                    }
                    String e = String.format("Raster layer '%s' is published in the mapserver.", f);
                    return e;
                }
                throw new GeoPublisherException(String.format("Failed to publish raster file '%s'. Error is %s", f, gs.getErrorCode()));
            }
        }
        if (vectorLayers.size() == 0 && rasterLayers.size() == 0) {
            throw new GeoPublisherException("No file defined for publication");
        }
        return null;
    }

    public static String addExternalFile(ACTION action, GeoServerRest gs, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException, GeoPublisherException {
        if (MapServersUtils.publishExternal(file, gs, action, metadataUuid, metadataTitle, metadataAbstract)) {
            return String.format("File '%s' is published in the mapserver.", file);
        }
        throw new GeoPublisherException(String.format("File '%s' not found in mapserver. Try to publish it? Status code is %s.", file, gs.getErrorCode()));
    }

    public static boolean publishVector(Path f, GeoFile gf, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String ds = f.getFileName().toString();
        String dsName = ds.substring(0, ds.lastIndexOf("."));
        try {
            if (action == ACTION.CREATE) {
                g.createDatastore(dsName, f, gf.getFormat());
                if (gf.containsSld().booleanValue()) {
                    g.createStyle(g.getDefaultWorkspace(), dsName, gf.getSld());
                } else {
                    g.createStyle(g.getDefaultWorkspace(), dsName);
                }
                g.createFeatureType(dsName, dsName, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action == ACTION.UPDATE) {
                g.createDatastore(dsName, f, gf.getFormat());
                g.createFeatureType(dsName, dsName, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action == ACTION.DELETE) {
                String report = "";
                if (!g.deleteLayer(dsName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!g.deleteFeatureType(dsName, dsName)) {
                    report = report + "Feature type: " + g.getStatus();
                }
                if (!g.deleteDatastore(dsName)) {
                    report = report + "Datastore: " + g.getStatus();
                }
                if (!report.equals("")) {
                    g.setErrorCode(report);
                    return false;
                }
                g.setReport(String.format("Layer '%s' remove from mapserver.", dsName));
                return true;
            }
            if (!g.getLayer(dsName)) {
                g.setErrorCode(String.format("Layer '%s' not found in mapserver. Try to publish it? Status code is %d.", dsName, g.getStatus()));
                return false;
            }
            g.setReport(g.getResponse());
            return true;
        }
        catch (Exception e) {
            g.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    public static boolean publishExternal(String file, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String dsName = file.substring(file.lastIndexOf("/") + 1, file.lastIndexOf("."));
        boolean isRaster = GeoFile.fileIsRASTER(file);
        Log.error((String)MODULE, (Object)("Publish external: " + dsName + ", Raster: " + isRaster));
        try {
            if (action == ACTION.CREATE) {
                if (isRaster) {
                    g.createCoverage(dsName, file, metadataUuid, metadataTitle, metadataAbstract);
                } else {
                    g.createDatastore(dsName, file);
                    g.createStyle(dsName);
                }
            } else if (action == ACTION.UPDATE) {
                if (isRaster) {
                    g.createCoverage(dsName, file, metadataUuid, metadataTitle, metadataAbstract);
                } else {
                    g.createDatastore(dsName, file);
                }
            } else if (action == ACTION.DELETE) {
                String report = "";
                if (!g.deleteLayer(dsName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!isRaster) {
                    if (!g.deleteFeatureType(dsName, dsName)) {
                        report = report + "Feature type: " + g.getStatus();
                    }
                    if (!g.deleteDatastore(dsName)) {
                        report = report + "Datastore: " + g.getStatus();
                    }
                }
                if (!report.equals("")) {
                    g.setErrorCode(report);
                    return false;
                }
            }
            if (!g.getLayer(dsName)) {
                g.setErrorCode(g.getStatus() + "");
                return false;
            }
            g.setReport(g.getResponse());
            return true;
        }
        catch (Exception e) {
            g.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    public static boolean publishRaster(Path f, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String cs = f.getFileName().toString();
        String csName = cs.substring(0, cs.lastIndexOf("."));
        try {
            if (action == ACTION.CREATE) {
                g.createCoverage(csName, f, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action == ACTION.UPDATE) {
                g.createCoverage(csName, f, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action == ACTION.DELETE) {
                String report = "";
                if (!g.deleteLayer(csName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!g.deleteCoverage(csName, csName)) {
                    report = report + "Coverage: " + g.getStatus();
                }
                if (!g.deleteCoverageStore(csName)) {
                    report = report + "Coveragestore: " + g.getStatus();
                }
                if (!report.equals("")) {
                    g.setErrorCode(report);
                    return false;
                }
            }
            if (!g.getLayer(csName)) {
                g.setErrorCode(g.getStatus() + "");
                return false;
            }
            g.setReport(g.getResponse());
            return true;
        }
        catch (Exception e) {
            g.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    public static enum ACTION {
        CREATE,
        UPDATE,
        DELETE,
        GET;

    }
}

