/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.util.Util;

public class ChangePassPhrase {
    private static String message = "\nSyntax: java ChangePassPhrase [-help] [-version] [-file private_key_file]\n\n\tChanges the passphrase that protects the private key. If the\n\t-file argument is not given, the default location of the file\n\tcontaining the private key is assumed:\n\n\t  -- " + CoGProperties.getDefault().getUserKeyFile() + "\n\n" + "\tOptions\n" + "\t-help | -usage\n" + "\t\tDisplay usage.\n" + "\t-version\n" + "\t\tDisplay version.\n" + "\t-file location\n" + "\t\tChange passphrase on key stored in the file at\n" + "\t\tthe non-standard location 'location'.\n\n";

    public static void main(String[] args) {
        String file = null;
        boolean error = false;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-file")) {
                file = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
                continue;
            }
            System.err.println("Error: argument not recognized : " + args[i]);
            error = true;
        }
        if (error) {
            System.err.println("\nUsage: java ChangePassPhrase [-help] [-version] [-file private_key_file]\n");
            System.err.println("Use -help to display full usage.");
            System.exit(1);
        }
        CertUtil.init();
        if (file == null) {
            file = CoGProperties.getDefault().getUserKeyFile();
        }
        BouncyCastleOpenSSLKey key = null;
        String pwd2 = null;
        try {
            String pwd1;
            key = new BouncyCastleOpenSSLKey(file);
            if (key.isEncrypted()) {
                pwd1 = Util.getPrivateInput("Enter OLD pass phrase: ");
                if (pwd1 == null || pwd1.length() == 0) {
                    return;
                }
                try {
                    key.decrypt(pwd1);
                }
                catch (Exception e) {
                    System.err.println("Error: Wrong pass phrase or key is invalid.");
                    if (debug) {
                        e.printStackTrace();
                    }
                    System.exit(1);
                }
            }
            if ((pwd1 = Util.getPrivateInput("Enter NEW pass phrase: ")) == null || pwd1.length() == 0) {
                return;
            }
            pwd2 = Util.getPrivateInput("Verifying password - Enter NEW pass phrase: ");
            if (pwd2 == null || pwd2.length() == 0) {
                return;
            }
            if (!pwd1.equals(pwd2)) {
                System.err.println("Error: Passwords do not match!");
                System.exit(1);
            }
            key.encrypt(pwd1);
            File newFile = Util.createFile(file + ".new");
            Util.setFilePermissions(newFile.getAbsolutePath(), 600);
            File oldFile = Util.createFile(file + ".old");
            Util.setFilePermissions(oldFile.getAbsolutePath(), 600);
            File crFile = Util.createFile(file);
            Util.setFilePermissions(crFile.getAbsolutePath(), 600);
            ChangePassPhrase.copy(crFile, oldFile);
            key.writeTo(newFile.getAbsolutePath());
            if (!crFile.delete()) {
                System.err.println("Error: failed to remove " + file + " file.");
                System.exit(1);
            }
            if (newFile.renameTo(crFile)) {
                System.out.println("Pass phrase successfully changed.");
            } else {
                System.err.println("Error: failed to rename the files.");
                System.exit(1);
            }
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unable to load the private key : " + e.getMessage());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File srcFile, File dstFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[1024];
        int bytes = 0;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(dstFile);
            Util.setFilePermissions(dstFile.getAbsolutePath(), 600);
            while ((bytes = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytes);
                out.flush();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {}
    }
}

