/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.IntCollection;
import bak.pcj.adapter.CollectionToIntCollectionAdapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyIntMap;
import bak.pcj.map.CharKeyIntMap;
import bak.pcj.map.CharKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyIntMapAdapter
extends AbstractCharKeyIntMap
implements CharKeyIntMap {
    protected Map map;
    protected Integer lastValue;

    public MapToCharKeyIntMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToCharKeyIntMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        this.lastValue = (Integer)this.map.get(new Character(key));
        return this.lastValue != null;
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(new Integer(value));
    }

    public CharKeyIntMapIterator entries() {
        return new CharKeyIntMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyIntMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public int getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public int get(char key) {
        Integer value = (Integer)this.map.get(new Character(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public int lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(char key, int value) {
        Integer oldValue = this.map.put(new Character(key), new Integer(value));
        return oldValue == null ? MapDefaults.defaultInt() : oldValue;
    }

    public int remove(char key) {
        Integer value = (Integer)this.map.remove(new Character(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public int size() {
        return this.map.size();
    }

    public IntCollection values() {
        return new CollectionToIntCollectionAdapter(this.map.values());
    }

    public int tget(char key) {
        Integer value = (Integer)this.map.get(new Character(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isCharKeyIntAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

