/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.FloatIteratorToIteratorAdapter;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class FloatSetToSetAdapter
extends AbstractSet {
    protected FloatSet set;

    public FloatSetToSetAdapter(FloatSet set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.set.add(((Float)o).floatValue());
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.set.contains(((Float)o).floatValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public Iterator iterator() {
        return new FloatIteratorToIteratorAdapter(this.set.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.set.remove(((Float)o).floatValue());
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.set.size();
    }
}

