/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractIntCollection;
import bak.pcj.Adapter;
import bak.pcj.IntIterator;
import bak.pcj.adapter.IteratorToIntIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToIntCollectionAdapter
extends AbstractIntCollection {
    protected Collection collection;

    public CollectionToIntCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToIntCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(int v) {
        return this.collection.add(new Integer(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(int v) {
        return this.collection.contains(new Integer(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public IntIterator iterator() {
        return new IteratorToIntIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(int v) {
        return this.collection.remove(new Integer(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isIntAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

