/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSFloatBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.FLOAT;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Float.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        String text = (String)value;
        if ("INF".equals(text)) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        return StringUtils.isBlank((CharSequence)text) ? null : Float.valueOf(text);
    }

    @Override
    public String encode(Object object, String value) {
        Float f = (Float)object;
        if (f.floatValue() == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        return f.toString();
    }
}

