/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.dlib.xml.XmlAttribute;
import org.dlib.xml.XmlCodec;
import org.dlib.xml.XmlDocument;
import org.dlib.xml.XmlElement;

public class XmlWriter {
    private String sSpace;
    private String sNewLine;

    public XmlWriter() {
        this("\t", true);
    }

    public XmlWriter(String string, boolean bl) {
        this.sSpace = string;
        this.sNewLine = bl ? System.getProperty("line.separator", "\n") : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, XmlDocument xmlDocument) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
        try {
            this.write(outputStreamWriter, xmlDocument);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    public void write(Writer writer, XmlDocument xmlDocument) throws IOException {
        writer.write(this.write(xmlDocument));
    }

    public String write(XmlDocument xmlDocument) {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append(this.sNewLine);
        stringBuffer.append(this.sNewLine);
        String string = xmlDocument.getDocType();
        if (string != null) {
            stringBuffer.append("<!DOCTYPE ");
            stringBuffer.append(string);
            stringBuffer.append(">");
            stringBuffer.append(this.sNewLine);
            stringBuffer.append(this.sNewLine);
        }
        stringBuffer.append(this.write(xmlDocument.getRootElement()));
        return stringBuffer.toString();
    }

    public String write(XmlElement xmlElement) {
        return this.buildXml(xmlElement, "");
    }

    private String buildXml(XmlElement xmlElement, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<");
        stringBuffer.append(xmlElement.getName());
        List list = xmlElement.getAttributes();
        for (int i = 0; i < list.size(); ++i) {
            XmlAttribute xmlAttribute = (XmlAttribute)list.get(i);
            stringBuffer.append(" ");
            stringBuffer.append(xmlAttribute.getName());
            stringBuffer.append("=");
            stringBuffer.append("\"" + XmlCodec.encode(xmlAttribute.getValue()) + "\"");
        }
        List list2 = xmlElement.getChildren();
        if (list2.size() == 0) {
            if (xmlElement.getValue().equals("")) {
                stringBuffer.append("/");
            } else {
                stringBuffer.append(">");
                stringBuffer.append(XmlCodec.encode(xmlElement.getValue()));
                stringBuffer.append("</");
                stringBuffer.append(xmlElement.getName());
            }
            stringBuffer.append(">" + this.sNewLine);
        } else {
            stringBuffer.append(">" + this.sNewLine);
            for (int i = 0; i < list2.size(); ++i) {
                XmlElement xmlElement2 = (XmlElement)list2.get(i);
                stringBuffer.append(this.buildXml(xmlElement2, string + this.sSpace));
            }
            stringBuffer.append(string);
            stringBuffer.append("</");
            stringBuffer.append(xmlElement.getName());
            stringBuffer.append(">" + this.sNewLine);
        }
        return stringBuffer.toString();
    }
}

