/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.repository.SourceRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class GeoNetworkPortalFilter
implements Filter {
    private static final String EXCLUDED_URL_PATHS = "excludedPaths";
    private static final String URL_PATH_SEPARATOR = "/";
    private List<AntPathRequestMatcher> excludedPathsMatchers = new ArrayList<AntPathRequestMatcher>();

    public void init(FilterConfig config) {
        ServletContext context = config.getServletContext();
        String excludedPathsValue = context.getInitParameter(EXCLUDED_URL_PATHS);
        if (StringUtils.isNotEmpty((CharSequence)excludedPathsValue)) {
            this.excludedPathsMatchers = Arrays.stream(excludedPathsValue.split(",")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        HttpServletRequest httpReq = (HttpServletRequest)req;
        if (!this.ignoreUrl(httpReq)) {
            String portal = "";
            portal = httpReq.getPathInfo().split(URL_PATH_SEPARATOR).length > 3 ? httpReq.getPathInfo().split(URL_PATH_SEPARATOR)[1] : "srv";
            if (!"srv".equals(portal)) {
                boolean redirectToDefaultPortal;
                SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
                boolean bl = redirectToDefaultPortal = !sourceRepository.existsByUuidAndType(portal, SourceType.subportal);
                if (redirectToDefaultPortal) {
                    String newPath = httpReq.getPathInfo().replace(URL_PATH_SEPARATOR + portal + URL_PATH_SEPARATOR, "/srv/");
                    if (httpReq.getQueryString() != null) {
                        newPath = newPath + "?" + httpReq.getQueryString();
                    }
                    httpResp.sendRedirect(httpReq.getContextPath() + newPath);
                    return;
                }
            }
        }
        filterChain.doFilter(req, resp);
    }

    public void destroy() {
    }

    private boolean ignoreUrl(HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)request.getPathInfo())) {
            return true;
        }
        return this.excludedPathsMatchers.stream().anyMatch(matcher -> matcher.matches(request));
    }
}

