/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.util.Collection;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserUtil {
    private UserUtil() {
    }

    public static boolean hasHierarchyRole(String role, RoleHierarchy roleHierarchy) {
        Collection authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        Collection hierarchyAuthorities = roleHierarchy.getReachableGrantedAuthorities(authorities);
        for (GrantedAuthority authority : hierarchyAuthorities) {
            if (!authority.getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }

    public static void checkUserProfileLevel(UserSession userSession, SettingManager settingManager, RoleHierarchy roleHierarchy, String settingConfigPath, Profile defaultProfile, String errorText) {
        String allowedUserProfileFromConfiguration;
        if (userSession.getProfile() != Profile.Administrator && !UserUtil.hasHierarchyRole(allowedUserProfileFromConfiguration = StringUtils.defaultIfBlank((String)settingManager.getValue(settingConfigPath), (String)defaultProfile.toString()), roleHierarchy)) {
            throw new NotAllowedException("The user has no permissions to " + errorText);
        }
    }
}

