/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.fao.geonet.utils.Log;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

public class JwtDecoderFactory {
    public JwtDecoder createJwtDecoder(String nStr, String eStr) throws Exception {
        if (nStr == null) {
            Log.warning((String)"geonetwork.security", (Object)"OpenID Connect - Bearer Token - public key - null 'n' value.");
        }
        if (eStr == null) {
            Log.warning((String)"geonetwork.security", (Object)"OpenID Connect - Bearer Token - public key - null 'e' value.");
        }
        Base64URL n = new Base64URL(nStr);
        Base64URL e = new Base64URL(eStr);
        BigInteger modulus = n.decodeToBigInteger();
        BigInteger exponent = e.decodeToBigInteger();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPublicKey publicKey = (RSAPublicKey)factory.generatePublic(spec);
        NimbusJwtDecoder decoder = NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
        return decoder;
    }
}

