/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import org.fao.geonet.domain.Profile;

public class LDAPRole {
    String groupName;
    Profile profile;

    public LDAPRole(String groupName, Profile profile) throws Exception {
        if (groupName == null || profile == null) {
            throw new Exception("groupName and profile must not be null");
        }
        this.groupName = groupName;
        this.profile = profile;
    }

    public LDAPRole(String groupName, String profileName) throws Exception {
        this.groupName = groupName;
        this.profile = Profile.findProfileIgnoreCase((String)profileName);
        if (groupName == null || this.profile == null) {
            throw new Exception("groupName and profile must not be null");
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) throws Exception {
        if (groupName == null) {
            throw new Exception("groupName must not be null");
        }
        this.groupName = groupName;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) throws Exception {
        if (profile == null) {
            throw new Exception("profile must not be null");
        }
        this.profile = profile;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LDAPRole)) {
            return false;
        }
        boolean groupNameEqual = this.getGroupName().equals(((LDAPRole)obj).getGroupName());
        boolean profileNameEqual = this.getProfile().name().equals(((LDAPRole)obj).getProfile().name());
        return groupNameEqual && profileNameEqual;
    }

    public int hashCode() {
        return this.getGroupName().hashCode() ^ this.getProfile().name().hashCode();
    }
}

