/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.DetachedRuleset;
import com.github.sommeri.less4j.core.ast.DetachedRulesetReference;
import com.github.sommeri.less4j.core.ast.EmbeddedScript;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableNamePart;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.strings.StringInterpolator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.IteratedScope;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.MixinReferenceFinder;
import com.github.sommeri.less4j.core.compiler.stages.MixinsReferenceMatcher;
import com.github.sommeri.less4j.core.compiler.stages.MixinsRulesetsSolver;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.QuotesKeepingInStringCssPrinter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReferencesSolver {
    public static final String ALL_ARGUMENTS = "@arguments";
    private ASTManipulator manipulator = new ASTManipulator();
    private final MixinsRulesetsSolver mixinsSolver;
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;
    private final AstNodesStack semiCompiledNodes = new AstNodesStack();
    private final StringInterpolator stringInterpolator;

    public ReferencesSolver(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
        this.stringInterpolator = new StringInterpolator(problemsHandler);
        this.mixinsSolver = new MixinsRulesetsSolver(this, this.semiCompiledNodes, problemsHandler, configuration);
    }

    public void solveReferences(ASTCssNode node, IScope scope) {
        this.doSolveReferences(node, new IteratedScope(scope));
    }

    private void doSolveReferences(final ASTCssNode node, final IteratedScope scope) {
        InScopeSnapshotRunner.runInLocalDataSnapshot(scope, new InScopeSnapshotRunner.ITask(){

            @Override
            public void run() {
                ReferencesSolver.this.unsafeDoSolveReferences(node, scope);
            }
        });
    }

    protected void unsafeDoSolveReferences(ASTCssNode node, IScope scope) {
        this.unsafeDoSolveReferences(node, new IteratedScope(scope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeDoSolveReferences(ASTCssNode node, IteratedScope iteratedScope) {
        this.semiCompiledNodes.push(node);
        try {
            ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
            if (!childs.isEmpty()) {
                IScope scope = iteratedScope.getScope();
                Map<ASTCssNode, GeneralBody> solvedReferences = this.solveCalls(childs, scope);
                this.solveNonCalligReferences(childs, iteratedScope);
                this.replaceMixinReferences(solvedReferences);
            }
        }
        finally {
            this.semiCompiledNodes.pop();
        }
    }

    private void solveNonCalligReferences(List<ASTCssNode> childs, IteratedScope iteratedScope) {
        ExpressionEvaluator cssGuardsValidator = new ExpressionEvaluator(iteratedScope.getScope(), this.problemsHandler, this.configuration);
        for (ASTCssNode kid : childs) {
            if (this.isMixinReference(kid) || this.isDetachedRulesetReference(kid)) continue;
            if (this.isRuleset(kid)) {
                RuleSet ruleSet = (RuleSet)kid;
                if (cssGuardsValidator.guardsSatisfied(ruleSet)) {
                    ruleSet.removeGuards();
                } else {
                    this.manipulator.removeFromClosestBody(ruleSet);
                    iteratedScope.getNextChild();
                    continue;
                }
            }
            if (AstLogic.isQuotelessUrlFunction(kid)) continue;
            if (AstLogic.hasOwnScope(kid)) {
                IteratedScope scope = iteratedScope.getNextChild();
                this.doSolveReferences(kid, scope);
                continue;
            }
            boolean finishedNode = this.solveIfVariableReference(kid, iteratedScope.getScope());
            if (finishedNode) continue;
            this.unsafeDoSolveReferences(kid, iteratedScope);
        }
    }

    private boolean isMixinReference(ASTCssNode kid) {
        return kid.getType() == ASTCssNodeType.MIXIN_REFERENCE;
    }

    private boolean isDetachedRulesetReference(ASTCssNode kid) {
        return kid.getType() == ASTCssNodeType.DETACHED_RULESET_REFERENCE;
    }

    private boolean isRuleset(ASTCssNode kid) {
        return kid.getType() == ASTCssNodeType.RULE_SET;
    }

    private void replaceMixinReferences(Map<ASTCssNode, GeneralBody> solvedReferences) {
        for (Map.Entry<ASTCssNode, GeneralBody> entry : solvedReferences.entrySet()) {
            ASTCssNode mixinReference = entry.getKey();
            GeneralBody replacement = entry.getValue();
            this.manipulator.setTreeSilentness(replacement, mixinReference.isSilent());
            this.manipulator.replaceInBody(mixinReference, replacement.getMembers());
        }
    }

    private Map<ASTCssNode, GeneralBody> solveCalls(List<ASTCssNode> childs, IScope referenceScope) {
        HashMap<ASTCssNode, GeneralBody> solvedMixinReferences = new HashMap<ASTCssNode, GeneralBody>();
        for (ASTCssNode kid : childs) {
            Expression evaluatedDetachedRuleset;
            if (this.isMixinReference(kid)) {
                MixinReference reference = (MixinReference)kid;
                List<FullMixinDefinition> foundMixins = this.findReferencedMixins(reference, referenceScope);
                GeneralBody replacement = this.mixinsSolver.buildMixinReferenceReplacement(reference, referenceScope, foundMixins);
                AstLogic.validateLessBodyCompatibility(reference, replacement.getMembers(), this.problemsHandler);
                solvedMixinReferences.put(reference, replacement);
                continue;
            }
            if (!this.isDetachedRulesetReference(kid)) continue;
            DetachedRulesetReference detachedRulesetReference = (DetachedRulesetReference)kid;
            Expression fullNodeDefinition = referenceScope.getValue(detachedRulesetReference.getVariable());
            if (fullNodeDefinition == null) {
                this.handleUnavailableDetachedRulesetReference(detachedRulesetReference, solvedMixinReferences);
                continue;
            }
            ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(referenceScope, this.problemsHandler, this.configuration);
            fullNodeDefinition = evaluatedDetachedRuleset = expressionEvaluator.evaluate(fullNodeDefinition);
            if (evaluatedDetachedRuleset.getType() != ASTCssNodeType.DETACHED_RULESET) {
                this.handleWrongDetachedRulesetReference(detachedRulesetReference, evaluatedDetachedRuleset, solvedMixinReferences);
                continue;
            }
            DetachedRuleset detachedRuleset = (DetachedRuleset)evaluatedDetachedRuleset;
            IScope scope = detachedRuleset.getScope();
            GeneralBody replacement = this.mixinsSolver.buildDetachedRulesetReplacement(detachedRulesetReference, referenceScope, detachedRuleset, scope);
            AstLogic.validateLessBodyCompatibility(kid, replacement.getMembers(), this.problemsHandler);
            solvedMixinReferences.put(kid, replacement);
        }
        return solvedMixinReferences;
    }

    private void handleUnavailableDetachedRulesetReference(DetachedRulesetReference detachedRulesetReference, Map<ASTCssNode, GeneralBody> solvedReferences) {
        this.problemsHandler.detachedRulesetNotfound(detachedRulesetReference);
        GeneralBody errorBody = new GeneralBody(detachedRulesetReference.getUnderlyingStructure());
        errorBody.addMember(new FaultyNode(detachedRulesetReference));
        solvedReferences.put(detachedRulesetReference, errorBody);
    }

    private void handleWrongDetachedRulesetReference(DetachedRulesetReference detachedRulesetReference, Expression value, Map<ASTCssNode, GeneralBody> solvedReferences) {
        this.problemsHandler.wrongDetachedRulesetReference(detachedRulesetReference, value);
        GeneralBody errorBody = new GeneralBody(detachedRulesetReference.getUnderlyingStructure());
        errorBody.addMember(new FaultyNode(detachedRulesetReference));
        solvedReferences.put(detachedRulesetReference, errorBody);
    }

    protected List<FullMixinDefinition> findReferencedMixins(MixinReference mixinReference, IScope scope) {
        MixinReferenceFinder finder = new MixinReferenceFinder(this, this.semiCompiledNodes);
        List<FullMixinDefinition> sameNameMixins = finder.getNearestMixins(scope, mixinReference);
        if (sameNameMixins.isEmpty()) {
            if (!finder.foundNamespace()) {
                this.problemsHandler.undefinedNamespace(mixinReference);
            }
            this.problemsHandler.undefinedMixin(mixinReference);
            return new ArrayList<FullMixinDefinition>();
        }
        MixinsReferenceMatcher matcher = new MixinsReferenceMatcher(scope, this.problemsHandler, this.configuration);
        List<FullMixinDefinition> mixins = matcher.filterByParametersNumber(mixinReference, sameNameMixins);
        if (mixins.isEmpty()) {
            this.problemsHandler.noMixinHasRightParametersCountError(mixinReference);
            return mixins;
        }
        if ((mixins = matcher.filterByPatterns(mixinReference, mixins)).isEmpty()) {
            this.problemsHandler.patternsInMatchingMixinsDoNotMatch(mixinReference);
        }
        return mixins;
    }

    private boolean solveIfVariableReference(ASTCssNode node, IScope scope) {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(scope, this.problemsHandler, this.configuration);
        switch (node.getType()) {
            case VARIABLE: {
                Expression replacement = expressionEvaluator.evaluate((Variable)node);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case INDIRECT_VARIABLE: {
                Expression replacement = expressionEvaluator.evaluate((IndirectVariable)node);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case STRING_EXPRESSION: {
                Expression replacement = expressionEvaluator.evaluate((CssString)node);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case ESCAPED_VALUE: {
                Expression replacement = expressionEvaluator.evaluate((EscapedValue)node);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case EMBEDDED_SCRIPT: {
                Expression replacement = expressionEvaluator.evaluate((EmbeddedScript)node);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case ESCAPED_SELECTOR: {
                SimpleSelector replacement = this.interpolateEscapedSelector((EscapedSelector)node, expressionEvaluator);
                this.manipulator.replaceAndSynchronizeSilentness(node, replacement);
                return true;
            }
            case FIXED_NAME_PART: {
                FixedNamePart part = (FixedNamePart)node;
                FixedNamePart replacement = this.interpolateFixedNamePart(part, expressionEvaluator);
                this.manipulator.replaceMemberAndSynchronizeSilentness(part, replacement);
                return true;
            }
            case VARIABLE_NAME_PART: {
                VariableNamePart part = (VariableNamePart)node;
                Expression value = expressionEvaluator.evaluate(part.getVariable());
                FixedNamePart fixedName = this.toFixedName(value, node.getUnderlyingStructure(), part);
                FixedNamePart replacement = this.interpolateFixedNamePart(fixedName, expressionEvaluator);
                this.manipulator.replaceMemberAndSynchronizeSilentness(part, replacement);
                return true;
            }
        }
        return false;
    }

    private FixedNamePart toFixedName(Expression value, HiddenTokenAwareTree parent, VariableNamePart part) {
        QuotesKeepingInStringCssPrinter printer = new QuotesKeepingInStringCssPrinter();
        printer.append(value);
        FixedNamePart fixedName = new FixedNamePart(parent, printer.toString());
        return fixedName;
    }

    private SimpleSelector interpolateEscapedSelector(EscapedSelector input, ExpressionEvaluator expressionEvaluator) {
        HiddenTokenAwareTree underlying = input.getUnderlyingStructure();
        String value = this.stringInterpolator.replaceIn(input.getValue(), expressionEvaluator, input.getUnderlyingStructure());
        InterpolableName interpolableName = new InterpolableName(underlying, new FixedNamePart(underlying, value));
        return new SimpleSelector(input.getUnderlyingStructure(), input.getLeadingCombinator(), interpolableName, false);
    }

    private FixedNamePart interpolateFixedNamePart(FixedNamePart input, ExpressionEvaluator expressionEvaluator) {
        String value = this.stringInterpolator.replaceIn(input.getName(), expressionEvaluator, input.getUnderlyingStructure());
        return new FixedNamePart(input.getUnderlyingStructure(), value);
    }
}

