/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.pdf.PdfPCell;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.BorderConfig;
import org.mapfish.print.config.layout.CellException;
import org.mapfish.print.config.layout.Exceptions;
import org.mapfish.print.utils.PJsonObject;

public class TableConfig
extends BorderConfig {
    private Exceptions cells;

    public void apply(PdfPCell cell, int row, int col, int nbRows, int nbCols, RenderingContext context, PJsonObject params) {
        if (this.cells != null) {
            for (int i = 0; i < this.cells.size(); ++i) {
                CellException cellException = (CellException)this.cells.get(i);
                if (!cellException.matches(row, col)) continue;
                cellException.apply(cell, context, params);
            }
        }
        if (row == 0) {
            if (this.borderWidthTop != null) {
                cell.setBorderWidthTop(this.borderWidthTop.floatValue());
            }
            if (this.getBorderColorTopVal(context, params) != null) {
                cell.setBorderColorTop(this.getBorderColorTopVal(context, params));
            }
        }
        if (col == 0) {
            if (this.borderWidthLeft != null) {
                cell.setBorderWidthLeft(this.borderWidthLeft.floatValue());
            }
            if (this.getBorderColorLeftVal(context, params) != null) {
                cell.setBorderColorLeft(this.getBorderColorLeftVal(context, params));
            }
        }
        if (row == nbRows - 1) {
            if (this.borderWidthBottom != null) {
                cell.setBorderWidthBottom(this.borderWidthBottom.floatValue());
            }
            if (this.getBorderColorBottomVal(context, params) != null) {
                cell.setBorderColorBottom(this.getBorderColorBottomVal(context, params));
            }
        }
        if (col == nbCols - 1) {
            if (this.borderWidthRight != null) {
                cell.setBorderWidthRight(this.borderWidthRight.floatValue());
            }
            if (this.getBorderColorRightVal(context, params) != null) {
                cell.setBorderColorRight(this.getBorderColorRightVal(context, params));
            }
        }
    }

    public void setCells(Exceptions cells) {
        this.cells = cells;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.cells != null) {
            for (int i = 0; i < this.cells.size(); ++i) {
                ((CellException)this.cells.get(i)).validate();
            }
        }
    }
}

