/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import opendap.servlet.BadURLException;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.BinaryFile;
import org.jdom.Element;

public class Log
implements Service {
    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String logfile = params.getChildText("file").trim();
        if (logfile.startsWith("http") || logfile.startsWith("ftp") || logfile.startsWith("sftp")) {
            throw new BadURLException("This is no proxy. Stopping possible hacking attempt to url: " + logfile);
        }
        if (!logfile.endsWith(".log")) {
            throw new BadURLException("Strange suffix for this log file. Stopping possible hacking attempt to uri: " + logfile);
        }
        if (!logfile.contains("harvester_")) {
            throw new BadURLException("This doesn't seem like a harvester log file. Stopping possible hacking attempt to uri: " + logfile);
        }
        File mainLogFile = GeonetworkDataDirectory.getLogfile();
        Path pathLogFile = mainLogFile != null ? mainLogFile.toPath().getParent().resolve(logfile) : Paths.get(logfile, new String[0]);
        if (!Files.exists(pathLogFile, new LinkOption[0]) || !Files.isReadable(pathLogFile)) {
            throw new NullPointerException(String.format("Couldn't find or read the logfile %s in catalogue log directory. Check log file configuration.", logfile));
        }
        return BinaryFile.encode((int)200, (Path)pathLogFile.toAbsolutePath().normalize(), (boolean)false).getElement();
    }
}

