/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.sftp.client;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.kernel.harvest.harvester.sftp.client.SftpFileInfo;

public class SftpClient {
    private static final String UTF8_BOM = "\ufeff";
    private final String host;
    private final int port;
    private final String username;
    private final JSch jsch;
    private ChannelSftp channel;
    private Session session;

    public SftpClient(String host, int port, String username) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.jsch = new JSch();
    }

    public SftpClient(String host, String username) {
        this(host, 22, username);
    }

    public void authPassword(String password) throws JSchException {
        this.session = this.jsch.getSession(this.username, this.host, this.port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.setPassword(password);
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    public void authKey(String keyPath, String pass) throws JSchException {
        this.jsch.addIdentity(keyPath, pass);
        this.session = this.jsch.getSession(this.username, this.host, this.port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    public List<SftpFileInfo> listFiles(String remoteDir, String fileExtension, boolean recurse) throws SftpException {
        this.checkChannel();
        ArrayList<SftpFileInfo> remoteFiles = new ArrayList<SftpFileInfo>();
        this.channel.cd(remoteDir);
        Vector files = this.channel.ls(".");
        for (ChannelSftp.LsEntry file : files) {
            if (file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
            if (file.getAttrs().isDir()) {
                if (!recurse) continue;
                remoteFiles.addAll(this.listFiles(remoteDir + file.getFilename() + "/", fileExtension, true));
                continue;
            }
            if (!FilenameUtils.getExtension((String)file.getFilename()).endsWith(fileExtension)) continue;
            remoteFiles.add(new SftpFileInfo(remoteDir, file.getFilename(), file.getAttrs().getMTime()));
        }
        return remoteFiles;
    }

    public void downloadFile(String remotePath, String localPath) throws SftpException {
        this.checkChannel();
        this.channel.get(remotePath, localPath);
    }

    public String getFileAsText(String remotePath) throws SftpException, IOException {
        this.checkChannel();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.channel.get(remotePath, (OutputStream)byteArrayOutputStream);
            String string = this.removeUTF8BOM(byteArrayOutputStream.toString(StandardCharsets.UTF_8.toString()));
            return string;
        }
    }

    public void close() {
        if (this.channel != null) {
            this.channel.exit();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    private void checkChannel() {
        if (this.channel == null) {
            throw new IllegalArgumentException("Connection is not available");
        }
    }

    private String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }
}

