/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Source;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeoNetworkHarvester;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.Aligner;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.GeonetParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.Search;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.GeoNetwork4ApiClient;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponse;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponseHit;

class Harvester
extends BaseGeoNetworkHarvester<GeonetParams>
implements IHarvester<HarvestResult> {
    private GeoNetwork4ApiClient geoNetworkApiClient;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, GeonetParams params, List<HarvestError> errors) {
        super(cancelMonitor, log, context, params, errors);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        String password;
        String username;
        this.log = log;
        this.geoNetworkApiClient = (GeoNetwork4ApiClient)this.context.getBean(GeoNetwork4ApiClient.class);
        if (((GeonetParams)this.params).isUseAccount()) {
            username = ((GeonetParams)this.params).getUsername();
            password = ((GeonetParams)this.params).getPassword();
        } else {
            username = "";
            password = "";
        }
        log.info("Retrieving information from : " + ((GeonetParams)this.params).host);
        String serverUrl = this.getServerUrl();
        Map<String, Source> sources = this.geoNetworkApiClient.retrieveSources(serverUrl, username, password);
        List<Group> groupList = this.geoNetworkApiClient.retrieveGroups(serverUrl, username, password);
        TreeSet<RecordInfo> records = new TreeSet<RecordInfo>(Comparator.comparing(RecordInfo::getUuid));
        boolean error = false;
        ArrayList searches = Lists.newArrayList(((GeonetParams)this.params).getSearches());
        if (((GeonetParams)this.params).isSearchEmpty()) {
            searches.add(Search.createEmptySearch(1, 2));
        }
        int pageSize = 30;
        for (Search s : searches) {
            if (this.cancelMonitor.get()) {
                return new HarvestResult();
            }
            log.info(String.format("Processing search with these parameters %s", s.toString()));
            int from = 0;
            int to = from + (pageSize - 1);
            s.setRange(from, to);
            long resultCount = Integer.MAX_VALUE;
            log.info("Searching on : " + ((GeonetParams)this.params).getName());
            while ((long)from < resultCount && !error) {
                try {
                    SearchResponse searchResponse = this.doSearch(s);
                    resultCount = searchResponse.getTotal();
                    records.addAll(this.processSearchResult(searchResponse.getHits()));
                }
                catch (Exception t) {
                    error = true;
                    log.error("Unknown error trying to harvest");
                    log.error(t.getMessage());
                    log.error((Throwable)t);
                    this.errors.add(new HarvestError(this.context, t));
                }
                catch (Throwable t) {
                    error = true;
                    log.fatal("Something unknown and terrible happened while harvesting");
                    log.fatal(t.getMessage());
                    log.error(t);
                    this.errors.add(new HarvestError(this.context, t));
                }
                s.setRange(from += pageSize, to += pageSize);
            }
        }
        log.info("Total records processed from this search :" + records.size());
        HarvestResult result = new HarvestResult();
        if (!error) {
            try {
                Aligner aligner = new Aligner(this.cancelMonitor, log, this.context, (GeonetParams)this.params, groupList);
                result = aligner.align(records, this.errors);
                this.updateSources(records, sources);
            }
            catch (Exception t) {
                log.error("Unknown error trying to harvest");
                log.error(t.getMessage());
                this.errors.add(new HarvestError(this.context, t));
            }
            catch (Throwable t) {
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(t.getMessage());
                this.errors.add(new HarvestError(this.context, t));
            }
        } else {
            log.warning("Due to previous errors the align process has not been called");
        }
        return result;
    }

    private Set<RecordInfo> processSearchResult(Set<SearchResponseHit> searchHits) {
        HashSet<RecordInfo> records = new HashSet<RecordInfo>(searchHits.size());
        for (SearchResponseHit md : searchHits) {
            if (this.cancelMonitor.get()) {
                return Collections.emptySet();
            }
            try {
                String uuid = md.getUuid();
                String schema = md.getSchema();
                String changeDate = md.getChangeDate();
                String source = md.getSource();
                records.add(new RecordInfo(uuid, changeDate, schema, source));
            }
            catch (Exception e) {
                HarvestError harvestError = new HarvestError(this.context, e);
                harvestError.setDescription("Malformed element '" + md.toString() + "'");
                harvestError.setHint("It seems that there was some malformed element. Check with your administrator.");
                this.errors.add(harvestError);
            }
        }
        return records;
    }

    private SearchResponse doSearch(Search s) throws OperationAbortedEx {
        try {
            String password;
            String username;
            if (((GeonetParams)this.params).isUseAccount()) {
                username = ((GeonetParams)this.params).getUsername();
                password = ((GeonetParams)this.params).getPassword();
            } else {
                username = "";
                password = "";
            }
            String queryBody = s.createElasticsearchQuery();
            return this.geoNetworkApiClient.query(this.getServerUrl(), queryBody, username, password);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            HarvestError harvestError = new HarvestError(this.context, ex);
            harvestError.setDescription("Error while searching on " + ((GeonetParams)this.params).getName() + ". ");
            harvestError.setHint("Check with your administrator.");
            this.errors.add(harvestError);
            throw new OperationAbortedEx("Raised exception when searching", (Object)ex);
        }
    }

    private String getServerUrl() {
        return ((GeonetParams)this.params).host + (((GeonetParams)this.params).host.endsWith("/") ? "" : "/") + ((GeonetParams)this.params).getNode();
    }
}

