/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geoPREST;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.geoPREST.Search;
import org.jdom.Element;

public class GeoPRESTParams
extends AbstractParams {
    private static int MAX_HARVEST_RESULTS = 100000;
    public String baseUrl;
    public String icon;
    public int maxResults;
    private List<Search> alSearches = new ArrayList<Search>();

    @Override
    public String getIcon() {
        return this.icon;
    }

    public GeoPRESTParams(DataManager dm) {
        super(dm);
    }

    @Override
    public void create(Element node) throws BadInputEx {
        super.create(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.baseUrl = Util.getParam((Element)site, (String)"baseUrl", (String)"");
        this.maxResults = MAX_HARVEST_RESULTS;
        this.icon = Util.getParam((Element)site, (String)"icon", (String)"default.gif");
        this.addSearches(searches);
    }

    @Override
    public void update(Element node) throws BadInputEx {
        super.update(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.baseUrl = Util.getParam((Element)site, (String)"baseUrl", (String)this.baseUrl);
        this.maxResults = MAX_HARVEST_RESULTS;
        this.icon = Util.getParam((Element)site, (String)"icon", (String)this.icon);
        if (searches != null) {
            this.addSearches(searches);
        }
    }

    public Iterable<Search> getSearches() {
        return this.alSearches;
    }

    public boolean isSearchEmpty() {
        return this.alSearches.isEmpty();
    }

    @Override
    public GeoPRESTParams copy() {
        GeoPRESTParams copy = new GeoPRESTParams(this.dm);
        this.copyTo(copy);
        copy.baseUrl = this.baseUrl;
        copy.icon = this.icon;
        for (Search s : this.alSearches) {
            copy.alSearches.add(s.copy());
        }
        return copy;
    }

    private void addSearches(Element searches) {
        this.alSearches.clear();
        if (searches == null) {
            return;
        }
        for (Object o : searches.getChildren("search")) {
            Element search = (Element)o;
            this.alSearches.add(new Search(search));
        }
    }
}

