/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.fragment;

import com.google.common.base.Optional;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.Privileges;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class FragmentHarvester
extends BaseAligner {
    private static final Namespace xlink = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private static final String REPLACEMENT_GROUP = "replacementGroup";
    private Logger log;
    private ServiceContext context;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private FragmentParams params;
    private String metadataGetService;
    private List<Namespace> metadataTemplateNamespaces = new ArrayList<Namespace>();
    private Set<String> templateIdAtts = new HashSet<String>();
    private Element metadataTemplate;
    private String harvestUri;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private HarvestSummary harvestSummary;
    private List<Privileges> fragmentAllPrivs = new ArrayList<Privileges>();

    public FragmentHarvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, FragmentParams params) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        String siteUrl = si.getSiteUrl() + context.getBaseUrl();
        this.metadataGetService = "local://" + context.getNodeId() + "/api/records/";
        if (params.templateId != null && !params.templateId.equals("") && !params.templateId.equals("0")) {
            this.loadTemplate();
        }
        Privileges fragmentPrivs = new Privileges("1");
        fragmentPrivs.add(0);
        this.fragmentAllPrivs.add(fragmentPrivs);
    }

    public HarvestSummary harvest(Element fragments, String harvestUri) throws Exception {
        this.harvestUri = harvestUri;
        this.harvestSummary = new HarvestSummary();
        if (fragments == null || !fragments.getName().equals("records")) {
            throw new BadXmlResponseEx("<records> not found in response: \n" + Xml.getString((Element)fragments));
        }
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        List recs = fragments.getChildren();
        for (Element rec : recs) {
            if (this.cancelMonitor.get()) break;
            this.addRecord(rec);
        }
        return this.harvestSummary;
    }

    private void loadTemplate() {
        try {
            this.metadataTemplate = this.metadataManager.getMetadata(this.params.templateId);
            Namespace ns = this.metadataTemplate.getNamespace();
            if (ns != null) {
                this.metadataTemplateNamespaces.add(ns);
                List additionalNamespaces = this.metadataTemplate.getAdditionalNamespaces();
                this.metadataTemplateNamespaces.addAll(additionalNamespaces);
            }
            new Document(this.metadataTemplate);
            List elems = Xml.selectNodes((Element)this.metadataTemplate, (String)"//*[@id]", this.metadataTemplateNamespaces);
            for (Object ob : elems) {
                if (!(ob instanceof Element)) continue;
                Element elem = (Element)ob;
                String idValue = elem.getAttributeValue("id");
                this.templateIdAtts.add(idValue);
            }
        }
        catch (Exception e) {
            this.log.error("Thrown Exception " + e + " opening template with id: " + this.params.templateId);
            this.log.error((Throwable)e);
        }
    }

    private void addRecord(Element rec) throws Exception {
        List fragments = rec.getChildren();
        Element recordMetadata = null;
        HashSet<String> recordMetadataRefs = new HashSet<String>();
        if (this.metadataTemplate != null) {
            recordMetadata = (Element)this.metadataTemplate.clone();
            recordMetadataRefs.addAll(this.templateIdAtts);
            new Document(recordMetadata);
        }
        for (Element fragment : fragments) {
            this.addMetadata(fragment);
            if (this.params.createSubtemplates.booleanValue()) {
                this.createSubtemplates(fragment);
            }
            if (recordMetadata == null) continue;
            this.updateMetadataReferences(recordMetadata, recordMetadataRefs, fragment);
        }
        if (recordMetadata != null) {
            this.cleanupRecord(recordMetadata, recordMetadataRefs);
        }
        this.harvestSummary.fragmentsReturned += fragments.size();
        if (recordMetadata != null) {
            String id;
            String recUuid = rec.getAttributeValue("uuid");
            if (recUuid == null || recUuid.trim().equals("")) {
                recUuid = UUID.randomUUID().toString();
            }
            if ((id = this.dataMan.getMetadataId(recUuid)) == null) {
                this.log.debug("Adding metadata " + recUuid);
                this.createMetadata(recUuid, recordMetadata);
            } else {
                this.log.debug("Updating metadata " + recUuid + " with id : " + id);
                this.updateMetadata(recUuid, id, recordMetadata);
            }
        }
    }

    private void addMetadata(Element fragment) {
        if (fragment.getName().equals(REPLACEMENT_GROUP)) {
            List children = fragment.getChildren();
            for (Element child : children) {
                this.addFragmentMetadata(child);
            }
        } else {
            this.addFragmentMetadata(fragment);
        }
    }

    private void addFragmentMetadata(Element fragment) {
        String setSchema;
        String uuid = fragment.getAttributeValue("uuid");
        if (uuid == null || uuid.equals("")) {
            uuid = UUID.randomUUID().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Metadata fragment did not have uuid! Fragment XML is " + Xml.getString((Element)fragment));
            }
            fragment.setAttribute("uuid", uuid);
        }
        if ((setSchema = fragment.getAttributeValue("schema")) == null || setSchema.trim().length() == 0) {
            fragment.setAttribute("schema", this.params.outputSchema);
        } else if (!this.dataMan.existsSchema(setSchema)) {
            this.log.warning("Skipping fragment with schema set to unknown schema: " + setSchema);
            ++this.harvestSummary.fragmentsUnknownSchema;
        }
    }

    private void createSubtemplates(Element fragment) throws Exception {
        if (fragment.getName().equals(REPLACEMENT_GROUP)) {
            List children = fragment.getChildren();
            for (Element child : children) {
                this.createOrUpdateSubtemplate(child);
            }
        } else {
            this.createOrUpdateSubtemplate(fragment);
        }
    }

    private void createOrUpdateSubtemplate(Element fragment) throws Exception {
        String uuid = fragment.getAttributeValue("uuid");
        String schema = fragment.getAttributeValue("schema");
        String title = fragment.getAttributeValue("title");
        if (schema == null) {
            return;
        }
        Element md = (Element)fragment.getChildren().get(0);
        String reference = this.metadataGetService + uuid;
        String id = this.dataMan.getMetadataId(uuid);
        if (id == null) {
            this.createSubtemplate(schema, md, uuid, title);
        } else {
            this.updateSubtemplate(id, uuid, md, title);
            Processor.uncacheXLinkUri((String)reference);
        }
        Processor.addXLinkToCache((String)reference, (Element)md);
    }

    private void updateSubtemplate(String id, String uuid, Element md, String title) throws Exception {
        this.update(id, md, title, true);
        this.harvestSummary.updatedMetadata.add(uuid);
        ++this.harvestSummary.fragmentsUpdated;
    }

    private void createSubtemplate(String schema, Element md, String uuid, String title) throws Exception {
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.SUB_TEMPLATE).setTitle(title);
        metadata.getSourceInfo().setSourceId(this.params.uuid).setOwner(Integer.valueOf(Integer.parseInt(this.params.owner)));
        metadata.getHarvestInfo().setHarvested(true).setUuid(this.params.uuid).setUri(this.harvestUri);
        this.addCategories((AbstractMetadata)metadata, this.params.categories, this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, this.fragmentAllPrivs, this.localGroups, this.context);
        this.dataMan.indexMetadata(id, true);
        this.metadataManager.flush();
        ++this.harvestSummary.fragmentsAdded;
    }

    private void updateMetadataReferences(Element template, Set<String> templateRefs, Element fragment) throws Exception {
        String matchId = fragment.getAttributeValue("id");
        if (matchId == null || matchId.equals("")) {
            this.log.error(fragment.getName() + " can't be matched because it has no id attribute " + Xml.getString((Element)fragment));
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to search metadata for " + matchId);
        }
        List elems = Xml.selectNodes((Element)template, (String)("//*[@id='" + matchId + "']"), this.metadataTemplateNamespaces);
        for (Object ob : elems) {
            if (!(ob instanceof Element)) continue;
            Element elem = (Element)ob;
            if (fragment.getName().equals(REPLACEMENT_GROUP)) {
                Element parent = elem.getParentElement();
                int insertionIndex = parent.indexOf((Content)elem);
                List children = fragment.getChildren();
                for (Element child : children) {
                    Element copy = (Element)elem.clone();
                    parent.addContent(insertionIndex++, (Content)copy);
                    this.updateTemplateReference(copy, child);
                }
                parent.removeContent((Content)elem);
                continue;
            }
            this.updateTemplateReference(elem, fragment);
        }
        if (elems.size() > 0) {
            ++this.harvestSummary.fragmentsMatched;
            templateRefs.remove(matchId);
        }
    }

    private void cleanupRecord(Element record, Set<String> recordRefs) throws Exception {
        this.log.debug("Cleaning up record with ids " + recordRefs);
        for (String matchId : recordRefs) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempting to search metadata for " + matchId);
            }
            List elems = Xml.selectNodes((Element)record, (String)("//*[@id='" + matchId + "']"), this.metadataTemplateNamespaces);
            for (Object ob : elems) {
                if (!(ob instanceof Element)) continue;
                Element elem = (Element)ob;
                Element parent = elem.getParentElement();
                parent.removeContent((Content)elem);
            }
        }
    }

    private void updateTemplateReference(Element reference, Element fragment) throws Exception {
        String title = fragment.getAttributeValue("title");
        String uuid = fragment.getAttributeValue("uuid");
        String schema = fragment.getAttributeValue("schema");
        boolean addUuid = fragment.getAttributeValue("addUuidAsId", "false").equals("true");
        if (schema == null) {
            return;
        }
        Element md = (Element)fragment.getChildren().get(0);
        if (this.params.createSubtemplates.booleanValue()) {
            reference.setAttribute("uuidref", uuid);
            reference.setAttribute("href", this.metadataGetService + uuid, xlink);
            reference.setAttribute("show", "replace", xlink);
            if (title != null) {
                reference.setAttribute("title", title, xlink);
            }
        } else {
            Element parent = reference.getParentElement();
            Element newMd = (Element)md.clone();
            if (addUuid) {
                newMd.setAttribute("id", uuid);
            }
            parent.setContent(parent.indexOf((Content)reference), (Content)newMd);
        }
    }

    private void updateMetadata(String recUuid, String id, Element template) throws Exception, SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\t- Attempting to update metadata record " + id + " with links");
        }
        template = this.dataMan.setUUID(this.params.outputSchema, recUuid, template);
        this.update(id, template, null, false);
        ++this.harvestSummary.recordsUpdated;
        this.harvestSummary.updatedMetadata.add(recUuid);
    }

    private void update(String id, Element template, String title, boolean isSubtemplate) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = new Date();
        boolean validate = false;
        boolean ufo = false;
        String language = this.context.getLanguage();
        this.metadataManager.updateMetadata(this.context, id, template, validate, ufo, language, df.format(date), false, IndexingMode.none);
        int iId = Integer.parseInt(id);
        IMetadataUtils metadataRepository = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
        AbstractMetadata metadata = metadataRepository.findOne(iId);
        OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
        repository.deleteAllByMetadataId(iId);
        if (isSubtemplate) {
            this.addPrivileges(id, this.fragmentAllPrivs, this.localGroups, this.context);
        } else {
            this.addPrivileges(id, this.params.privileges, this.localGroups, this.context);
        }
        metadata.getCategories().clear();
        this.addCategories(metadata, this.params.categories, this.localCateg, this.context, null, true);
        if (isSubtemplate) {
            this.dataMan.setSubtemplateTypeAndTitleExt(iId, title);
        }
        this.dataMan.setHarvestedExt(iId, this.params.uuid, Optional.of((Object)this.harvestUri));
        this.dataMan.indexMetadata(id, true);
        this.metadataManager.flush();
    }

    private void createMetadata(String recUuid, Element template) throws Exception, SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\t- Attempting to insert metadata record with link");
        }
        template = this.dataMan.setUUID(this.params.outputSchema, recUuid, template);
        Metadata metadata = new Metadata();
        metadata.setUuid(recUuid);
        metadata.getDataInfo().setSchemaId(this.params.outputSchema).setRoot(template.getQualifiedName()).setType(MetadataType.METADATA);
        metadata.getSourceInfo().setSourceId(this.params.uuid).setOwner(Integer.valueOf(Integer.parseInt(this.params.owner)));
        metadata.getHarvestInfo().setHarvested(true).setUuid(this.params.uuid).setUri(this.harvestUri);
        if (this.params.isoCategory != null) {
            MetadataCategory metadataCategory = ((MetadataCategoryRepository)this.context.getBean(MetadataCategoryRepository.class)).findOneByName(this.params.isoCategory);
            if (metadataCategory == null) {
                throw new IllegalArgumentException("No category found with name: " + this.params.isoCategory);
            }
            metadata.getCategories().add(metadataCategory);
        }
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, template, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("\t- Set privileges, category, template and harvested");
        }
        this.addPrivileges(id, this.params.privileges, this.localGroups, this.context);
        this.dataMan.indexMetadata(id, true);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\t- Commit " + id);
        }
        this.metadataManager.flush();
        ++this.harvestSummary.recordsBuilt;
    }

    public static class HarvestSummary {
        public int fragmentsMatched;
        public int recordsBuilt;
        public int recordsUpdated;
        public int fragmentsReturned;
        public int fragmentsAdded;
        public int fragmentsUpdated;
        public int fragmentsUnknownSchema;
        public Set<String> updatedMetadata = new HashSet<String>();
    }

    public static class FragmentParams {
        public String uuid;
        public String owner;
        public String templateId;
        public String outputSchema;
        public String isoCategory;
        public Boolean createSubtemplates;
        public Iterable<Privileges> privileges;
        public Iterable<String> categories;
    }
}

