/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspire.validator;

import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.exceptions.ServiceNotFoundEx;
import org.fao.geonet.inspire.validator.InspireValidatorException;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpResponse;

public class InspireValidatorUtils {
    @Autowired
    private GeonetHttpRequestFactory requestFactory;
    @Autowired
    SettingManager settingManager;
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String ACCEPT = "application/json";
    private static final String CHECKSTATUS_URL = "/v2/status";
    private static final String EXECUTABLETESTSUITES_URL = "/v2/ExecutableTestSuites";
    private static final String TESTOBJECTS_URL = "/v2/TestObjects";
    private static final String TESTRUNS_URL = "/v2/TestRuns";
    public static final String TEST_STATUS_PASSED = "PASSED";
    public static final String TEST_STATUS_FAILED = "FAILED";
    public static final String TEST_STATUS_PASSED_MANUAL = "PASSED_MANUAL";
    public static final String TEST_STATUS_UNDEFINED = "UNDEFINED";
    public static final String TEST_STATUS_NOT_APPLICABLE = "NOT_APPLICABLE";
    public static final String TEST_STATUS_INTERNAL_ERROR = "INTERNAL_ERROR";
    @Value(value="#{validatorAdditionalConfig['defaultTestSuite']}")
    public String defaultTestSuite;
    @Resource(name="inspireEtfValidatorTestsuites")
    private Map<String, String[]> testsuites;
    @Resource(name="inspireEtfValidatorTestsuitesConditions")
    private Map<String, String> testsuitesConditions;
    @Value(value="#{validatorAdditionalConfig['maxNumberOfEtfChecks']}")
    private Integer maxNumberOfEtfChecks;
    @Value(value="#{validatorAdditionalConfig['intervalBetweenEtfChecks']}")
    private Long intervalBetweenEtfChecks;

    public String getDefaultTestSuite() {
        return this.defaultTestSuite;
    }

    public void setDefaultTestSuite(String defaultTestSuite) {
        this.defaultTestSuite = defaultTestSuite;
    }

    public void setTestsuites(Map<String, String[]> testsuites) {
        this.testsuites = testsuites;
    }

    public Map<String, String[]> getTestsuites() {
        return this.testsuites;
    }

    public void setTestsuitesConditions(Map<String, String> testsuitesConditions) {
        this.testsuitesConditions = testsuitesConditions;
    }

    public Map<String, String> getTestsuitesConditions() {
        return this.testsuitesConditions;
    }

    public Integer getMaxNumberOfEtfChecks() {
        return this.maxNumberOfEtfChecks;
    }

    public void setMaxNumberOfEtfChecks(Integer maxNumberOfEtfChecks) {
        this.maxNumberOfEtfChecks = maxNumberOfEtfChecks;
    }

    public Long getIntervalBetweenEtfChecks() {
        return this.intervalBetweenEtfChecks;
    }

    public void setIntervalBetweenEtfChecks(Long intervalBetweenEtfChecks) {
        this.intervalBetweenEtfChecks = intervalBetweenEtfChecks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkServiceStatus(ServiceContext context, String endPoint) {
        HttpGet request = new HttpGet(StringUtils.removeEnd((String)endPoint, (String)"/") + CHECKSTATUS_URL);
        request.addHeader("User-Agent", USER_AGENT);
        request.addHeader("Accept", ACCEPT);
        try (ClientHttpResponse response = this.execute(context, (HttpUriRequest)request);){
            if (response.getStatusCode().value() == 200) {
                boolean bl2 = true;
                return bl2;
            }
            Log.warning((String)"jeeves.service", (Object)("INSPIRE service not available: " + endPoint + CHECKSTATUS_URL));
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Log.warning((String)"jeeves.service", (Object)("Error calling INSPIRE service: " + endPoint), (Throwable)e);
            return false;
        }
    }

    private String uploadMetadataFile(ServiceContext context, String endPoint, InputStream xml) throws InspireValidatorException {
        ClientHttpResponse response;
        block6: {
            HttpPost request = new HttpPost(StringUtils.removeEnd((String)endPoint, (String)"/") + TESTOBJECTS_URL + "?action=upload");
            request.addHeader("User-Agent", USER_AGENT);
            request.addHeader("Accept", ACCEPT);
            response = null;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("fileupload", xml, ContentType.TEXT_XML, "file.xml");
            HttpEntity entity = builder.build();
            request.setEntity(entity);
            response = this.execute(context, (HttpUriRequest)request);
            if (response.getStatusCode().value() != 200) break block6;
            new BasicResponseHandler();
            String body = CharStreams.toString((Readable)new InputStreamReader(response.getBody()));
            JSONObject jsonRoot = new JSONObject(body);
            String string = jsonRoot.getJSONObject("testObject").getString("id");
            IOUtils.closeQuietly((Closeable)response);
            return string;
        }
        try {
            try {
                Log.error((String)"jeeves.service", (Object)("INSPIRE service HTTP response: " + response.getStatusCode().value() + " for " + TESTOBJECTS_URL));
                throw new InspireValidatorException(String.format("INSPIRE service - error uploading file: %s, error code: %d", response.getStatusText(), response.getStatusCode().value()));
            }
            catch (InspireValidatorException e) {
                throw e;
            }
            catch (Exception e) {
                Log.error((String)"jeeves.service", (String)("Error calling INSPIRE service: " + endPoint), (Throwable)e);
                throw new InspireValidatorException(String.format("Error calling INSPIRE service: %s, %s", endPoint, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getTests(ServiceContext context, String endPoint, String testsuite) {
        int i;
        JSONArray executableTestSuiteArray;
        ArrayList<String> testList;
        String[] tests;
        if (testsuite == null) {
            testsuite = this.getDefaultTestSuite();
        }
        HttpGet request = new HttpGet(StringUtils.removeEnd((String)endPoint, (String)"/") + EXECUTABLETESTSUITES_URL);
        request.addHeader("User-Agent", USER_AGENT);
        request.addHeader("Accept", ACCEPT);
        try (ClientHttpResponse response = this.execute(context, (HttpUriRequest)request);){
            tests = this.testsuites.get(testsuite);
            if (response.getStatusCode().value() != 200) {
                Log.warning((String)"jeeves.service", (Object)("WARNING: INSPIRE service HTTP response: " + response.getStatusCode().value() + " for " + EXECUTABLETESTSUITES_URL));
                List<String> list = Collections.emptyList();
                return list;
            }
            testList = new ArrayList<String>();
            new BasicResponseHandler();
            String body = CharStreams.toString((Readable)new InputStreamReader(response.getBody()));
            JSONObject jsonRoot = new JSONObject(body);
            JSONObject etfItemCollection = jsonRoot.getJSONObject("EtfItemCollection");
            JSONObject executableTestSuites = etfItemCollection.getJSONObject("executableTestSuites");
            executableTestSuiteArray = executableTestSuites.getJSONArray("ExecutableTestSuite");
            i = 0;
        }
        catch (Exception e) {
            Log.error((String)"jeeves.service", (String)("Exception in INSPIRE service: " + endPoint), (Throwable)e);
            return Collections.emptyList();
        }
        while (i < executableTestSuiteArray.length()) {
            JSONObject test = executableTestSuiteArray.getJSONObject(i);
            boolean ok = false;
            for (String testToRun : tests) {
                ok = ok || testToRun.equals(test.getString("label"));
            }
            if (ok) {
                testList.add(test.getString("id"));
            }
            ++i;
        }
        return testList;
    }

    private String testRun(ServiceContext context, String endPoint, String fileId, List<String> testList, String testTitle) throws InspireValidatorException {
        ClientHttpResponse response;
        block9: {
            String testId;
            HttpPost request = new HttpPost(StringUtils.removeEnd((String)endPoint, (String)"/") + TESTRUNS_URL);
            request.setHeader("Content-type", ACCEPT);
            request.addHeader("User-Agent", USER_AGENT);
            request.addHeader("Accept", ACCEPT);
            this.addApiKey((HttpRequestBase)request);
            response = null;
            JSONObject json = new JSONObject();
            JSONArray tests = new JSONArray();
            JSONObject arguments = new JSONObject();
            JSONObject testObject = new JSONObject();
            json.put("label", (Object)("TEST " + testTitle + " - " + System.currentTimeMillis()));
            json.put("executableTestSuiteIds", (Object)tests);
            json.put("arguments", (Object)arguments);
            json.put("testObject", (Object)testObject);
            for (String test : testList) {
                tests.put((Object)test);
            }
            arguments.put("files_to_test", (Object)".*");
            arguments.put("tests_to_execute", (Object)".*");
            if (fileId.startsWith("http")) {
                JSONObject resourceObject = new JSONObject();
                resourceObject.put("data", (Object)fileId);
                testObject.put("resources", (Object)resourceObject);
            } else {
                testObject.put("id", (Object)fileId);
            }
            StringEntity entity = new StringEntity(json.toString());
            request.setEntity((HttpEntity)entity);
            response = this.execute(context, (HttpUriRequest)request);
            if (response.getStatusCode().value() != 201) break block9;
            String body = CharStreams.toString((Readable)new InputStreamReader(response.getBody()));
            JSONObject jsonRoot = new JSONObject(body);
            String string = testId = jsonRoot.getJSONObject("EtfItemCollection").getJSONObject("testRuns").getJSONObject("TestRun").getString("id");
            IOUtils.closeQuietly((Closeable)response);
            return string;
        }
        try {
            try {
                Log.warning((String)"jeeves.service", (Object)("WARNING: INSPIRE service HTTP response: " + response.getStatusCode().value() + " for " + TESTRUNS_URL));
                throw new InspireValidatorException(String.format("Error while creating test on validator side. Status is: %d (%s). Error: %s", response.getStatusCode().value(), response.getStatusText(), response.getBody() != null ? CharStreams.toString((Readable)new InputStreamReader(response.getBody())) : ""));
            }
            catch (InspireValidatorException e) {
                throw e;
            }
            catch (Exception e) {
                Log.error((String)"jeeves.service", (String)("Exception in INSPIRE service: " + endPoint), (Throwable)e);
                throw new InspireValidatorException(String.format("Error calling INSPIRE service: %s, %s", endPoint, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response);
            throw throwable;
        }
    }

    private void addApiKey(HttpRequestBase request) {
        String apikey = this.settingManager.getValue("system/inspire/remotevalidation/apikey");
        if (StringUtils.isNotEmpty((String)apikey)) {
            request.addHeader("X-API-key", apikey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReady(ServiceContext context, String endPoint, String testId) throws ResourceNotFoundException, InspireValidatorException {
        if (testId == null) {
            return false;
        }
        HttpGet request = new HttpGet(StringUtils.removeEnd((String)endPoint, (String)"/") + TESTRUNS_URL + "/" + testId + "/progress");
        request.addHeader("User-Agent", USER_AGENT);
        request.addHeader("Accept", ACCEPT);
        this.addApiKey((HttpRequestBase)request);
        try (ClientHttpResponse response = this.execute(context, (HttpUriRequest)request);){
            if (response.getStatusCode().value() == 200) {
                String body = CharStreams.toString((Readable)new InputStreamReader(response.getBody()));
                JSONObject jsonRoot = new JSONObject(body);
                boolean bl = jsonRoot.getInt("val") == jsonRoot.getInt("max") && this.isPassed(context, endPoint, testId) != null;
                return bl;
            }
            if (response.getStatusCode().value() == 404) {
                throw new ResourceNotFoundException("Test not found");
            }
            Log.warning((String)"jeeves.service", (Object)("WARNING: INSPIRE service HTTP response: " + response.getStatusCode().value() + " for " + TESTRUNS_URL + "?view=progress"));
            return false;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            Log.error((String)"jeeves.service", (String)("Exception in INSPIRE service: " + endPoint), (Throwable)e);
            throw new InspireValidatorException(String.format("Exception in INSPIRE service: %s, %s", endPoint, e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public String isPassed(ServiceContext context, String endPoint, String testId) throws InspireValidatorException {
        block26: {
            if (testId == null) {
                throw new InspireValidatorException(String.format("Exception in INSPIRE service: %s, test not provided", endPoint));
            }
            HttpGet request = new HttpGet(StringUtils.removeEnd((String)endPoint, (String)"/") + TESTRUNS_URL + "/" + testId);
            request.addHeader("User-Agent", USER_AGENT);
            request.addHeader("Accept", ACCEPT);
            this.addApiKey((HttpRequestBase)request);
            try {
                Throwable throwable = null;
                try (ClientHttpResponse response = this.execute(context, (HttpUriRequest)request);){
                    block27: {
                        if (response.getStatusCode().value() != 200) break block27;
                        String body = CharStreams.toString((Readable)new InputStreamReader(response.getBody()));
                        JSONObject jsonRoot = new JSONObject(body);
                        try {
                            String string = jsonRoot.getJSONObject("EtfItemCollection").getJSONObject("testRuns").getJSONObject("TestRun").getString("status");
                            return string;
                        }
                        catch (JSONException e) {
                            String string;
                            block24: {
                                block25: {
                                    string = null;
                                    if (response == null) break block24;
                                    if (throwable == null) break block25;
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block24;
                                }
                                response.close();
                            }
                            return string;
                        }
                    }
                    if (response.getStatusCode().value() == 404) {
                        throw new ResourceNotFoundException("Test not found");
                    }
                    Log.warning((String)"jeeves.service", (Object)("WARNING: INSPIRE service HTTP response: " + response.getStatusCode().value() + " for " + TESTRUNS_URL + "?view=progress"));
                    break block26;
                    {
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.error((String)"jeeves.service", (String)("Exception in INSPIRE service: " + endPoint), (Throwable)e);
                throw new InspireValidatorException(String.format("Exception in INSPIRE service: %s, %s", endPoint, e));
            }
        }
        return null;
    }

    public String getReportUrl(String endPoint, String testId) {
        return endPoint + TESTRUNS_URL + "/" + testId + ".html";
    }

    public static String getReportUrlJSON(String endPoint, String testId) {
        return endPoint + TESTRUNS_URL + "/" + testId + ".json";
    }

    public static String getReportUrlXML(String endPoint, String testId) {
        return endPoint + TESTRUNS_URL + "/" + testId + ".xml";
    }

    public String submitFile(ServiceContext context, String serviceEndpoint, String serviceQueryEndpoint, InputStream metadataRecord, String testsuite, String testTitle) throws InspireValidatorException {
        if (this.checkServiceStatus(context, serviceQueryEndpoint)) {
            List<String> tests = this.getTests(context, serviceQueryEndpoint, testsuite);
            String testFileId = this.uploadMetadataFile(context, serviceQueryEndpoint, metadataRecord);
            if (testFileId == null) {
                Log.error((String)"jeeves.service", (String)"File not valid.", (Throwable)new IllegalArgumentException());
                return null;
            }
            if (tests.isEmpty()) {
                Log.error((String)"jeeves.service", (String)"Default test sequence not supported. Check org.fao.geonet.inspire.validator.InspireValidatorUtils.TESTS_TO_RUN_TG13.", (Throwable)new Exception());
                return null;
            }
            return this.testRun(context, serviceEndpoint, testFileId, tests, testTitle);
        }
        Log.error((String)"jeeves.service", (String)String.format("INSPIRE service end-point unavailable: %s", serviceEndpoint), (Throwable)((Object)new InspireValidatorException()));
        throw new InspireValidatorException(String.format("INSPIRE service end-point unavailable: %s", serviceEndpoint));
    }

    public String submitUrl(ServiceContext context, String serviceEndpoint, String serviceEndpointQuery, String getRecordById, String testsuite, String testTitle) throws InspireValidatorException {
        if (this.checkServiceStatus(context, serviceEndpointQuery)) {
            List<String> tests = this.getTests(context, serviceEndpoint, testsuite);
            if (tests.isEmpty()) {
                Log.error((String)"jeeves.service", (String)"Default test sequence not supported. Check org.fao.geonet.inspire.validator.InspireValidatorUtils.TESTS_TO_RUN_TG13.", (Throwable)new Exception());
                return null;
            }
            return this.testRun(context, serviceEndpoint, getRecordById, tests, testTitle);
        }
        ServiceNotFoundEx ex = new ServiceNotFoundEx(serviceEndpoint);
        Log.error((String)"jeeves.service", (String)"Service unavailable.", (Throwable)ex);
        throw ex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String retrieveReport(ServiceContext context, String endPoint) throws InspireValidatorException {
        HttpGet request = new HttpGet(endPoint);
        request.addHeader("User-Agent", USER_AGENT);
        request.addHeader("Accept", ACCEPT);
        try (ClientHttpResponse response = this.execute(context, (HttpUriRequest)request);){
            String string = IOUtils.toString((InputStream)response.getBody(), (String)StandardCharsets.UTF_8.name());
            return string;
        }
        catch (Exception e) {
            Log.warning((String)"jeeves.service", (Object)("Error calling INSPIRE service to retrieve the result report: " + endPoint), (Throwable)e);
            throw new InspireValidatorException(String.format("Error calling INSPIRE service to retrieve the result report: %s, %s", endPoint, e.getMessage()));
        }
    }

    public void waitUntilReady(ServiceContext context, String endPoint, String testId) throws ResourceNotFoundException, InterruptedException, InspireValidatorException {
        int checkCounter = 1;
        while (checkCounter++ <= this.maxNumberOfEtfChecks) {
            if (this.isReady(context, endPoint, testId)) {
                return;
            }
            Thread.sleep(this.intervalBetweenEtfChecks);
        }
        throw new InspireValidatorException(String.format("ETF validation task hasn't finish after %d checks.", this.maxNumberOfEtfChecks));
    }

    public MetadataValidationStatus calculateValidationStatus(String validationStatus) {
        MetadataValidationStatus metadataValidationStatus;
        boolean executed;
        boolean isUndefined = validationStatus.equalsIgnoreCase(TEST_STATUS_UNDEFINED);
        boolean isNotApplicable = validationStatus.equalsIgnoreCase(TEST_STATUS_NOT_APPLICABLE);
        boolean bl = executed = !validationStatus.equalsIgnoreCase(TEST_STATUS_INTERNAL_ERROR);
        if (isNotApplicable) {
            metadataValidationStatus = MetadataValidationStatus.DOES_NOT_APPLY;
        } else if (!isUndefined && executed) {
            boolean isValid = validationStatus.equalsIgnoreCase(TEST_STATUS_PASSED) || validationStatus.equalsIgnoreCase(TEST_STATUS_PASSED_MANUAL);
            metadataValidationStatus = isValid ? MetadataValidationStatus.VALID : MetadataValidationStatus.INVALID;
        } else {
            metadataValidationStatus = MetadataValidationStatus.NEVER_CALCULATED;
        }
        return metadataValidationStatus;
    }

    public Map<String, String> calculateTestsuitesToApply(String schemaid, IMetadataSchemaUtils metadataSchemaUtils) {
        Map<String, String> allTestsuitesConditions = this.getTestsuitesConditions();
        Map<String, String> testsuitesConditionsForSchema = allTestsuitesConditions.entrySet().stream().filter(x -> ((String)x.getKey()).split("::")[0].equalsIgnoreCase(schemaid)).collect(Collectors.toMap(map -> ((String)map.getKey()).split("::")[1], Map.Entry::getValue));
        if (testsuitesConditionsForSchema.isEmpty()) {
            MetadataSchema metadataSchema = metadataSchemaUtils.getSchema(schemaid);
            HashSet<String> schemasProcessed = new HashSet<String>();
            String schemaDependsOn = metadataSchema.getDependsOn();
            boolean conditionsFound = false;
            while (StringUtils.isNotEmpty((String)schemaDependsOn) && !schemasProcessed.contains(schemaDependsOn) && !conditionsFound) {
                schemasProcessed.add(schemaDependsOn);
                String schemaDependsOnFilter = schemaDependsOn;
                testsuitesConditionsForSchema = allTestsuitesConditions.entrySet().stream().filter(x -> ((String)x.getKey()).split("::")[0].equalsIgnoreCase(schemaDependsOnFilter)).collect(Collectors.toMap(map -> ((String)map.getKey()).split("::")[1], Map.Entry::getValue));
                conditionsFound = !testsuitesConditionsForSchema.isEmpty();
                if (conditionsFound) continue;
                metadataSchema = metadataSchemaUtils.getSchema(schemaDependsOn);
                schemaDependsOn = metadataSchema.getDependsOn();
            }
        }
        return testsuitesConditionsForSchema;
    }

    private ClientHttpResponse execute(final ServiceContext context, final HttpUriRequest request) throws IOException {
        Function<HttpClientBuilder, Void> proxyConfiguration = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                Lib.net.setupProxy(context, input, request.getURI().getHost());
                return null;
            }
        };
        return this.requestFactory.execute(request, (Function)proxyConfiguration);
    }
}

