/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiapi.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.utils.XML11Char;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class XsltResponseWriter {
    public static final String TRANSLATIONS = "translations";
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    Element xml;
    Path xsl;
    Map<String, Object> xslParams = new HashMap<String, Object>();

    public XsltResponseWriter(String envTagName, String serviceName) {
        this(envTagName, serviceName, "eng");
    }

    public XsltResponseWriter(String envTagName, String serviceName, String lang) {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String url = settingManager.getBaseURL();
        Element gui = new Element("gui");
        gui.addContent((Content)new Element("url").setText(url.substring(0, url.length() - 1)));
        gui.addContent((Content)new Element("nodeUrl").setText(settingManager.getNodeURL()));
        gui.addContent((Content)new Element("baseUrl").setText(settingManager.getBaseURL()));
        gui.addContent((Content)new Element("serverUrl").setText(settingManager.getServerURL()));
        gui.addContent((Content)new Element("language").setText(lang));
        Element settings = settingManager.getAllAsXML(true);
        settings.setName(StringUtils.isNotEmpty((String)envTagName) ? envTagName : "systemConfig");
        gui.addContent((Content)settings);
        gui.addContent((Content)new Element("reqService").setText(serviceName));
        Element translations = new Element(TRANSLATIONS);
        this.xml = new Element("root").addContent((Content)gui).addContent((Content)translations);
    }

    public XsltResponseWriter withXml(Element xml) {
        this.xml.addContent((Content)xml);
        return this;
    }

    public XsltResponseWriter withXsl(String xsl) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        this.xsl = dataDirectory.getWebappDir().resolve(xsl);
        return this;
    }

    public XsltResponseWriter withParam(String k, Object v) {
        this.xslParams.put(k, v);
        return this;
    }

    public XsltResponseWriter withParams(Map<String, Object> params) {
        this.xslParams.putAll(params);
        return this;
    }

    public Element asElement() throws Exception {
        return Xml.transform((Element)this.xml, (Path)this.xsl, this.xslParams);
    }

    public String asHtml() throws Exception {
        return Xml.getString((Element)this.asElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asPdf(HttpServletResponse response, String fileName) throws Exception {
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Path file = Xml.transformFOP((Path)dataDirectory.getUploadDir(), (Element)this.xml, (String)this.xsl.toString());
        try {
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setContentLength((int)file.toFile().length());
            response.getOutputStream().write(Files.readAllBytes(file));
            response.getOutputStream().flush();
        }
        finally {
            FileUtils.deleteQuietly((File)file.toFile());
        }
    }

    public XsltResponseWriter withJson(String json) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        Path jsonPath = dataDirectory.getWebappDir().resolve(json);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map values = (Map)mapper.readValue(jsonPath.toFile(), Map.class);
            Element element = this.xml.getChild(TRANSLATIONS);
            values.forEach((k, v) -> {
                if (XML11Char.isXML11ValidNCName((String)k)) {
                    element.addContent((Content)new Element(k).setText(v));
                } else {
                    Log.warning((String)"geonetwork", (Object)String.format("JSON key '%s' can't be used in XSLT API response. Avoid usage of XML invalid characters in keys if this key is required in XSLT processing.", k));
                }
            });
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork", (Object)String.format("Can't find JSON file '%s'.", jsonPath));
        }
        return this;
    }
}

