/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.users.model.UserRegisterDto;
import org.fao.geonet.api.users.recaptcha.RecaptchaChecker;
import org.fao.geonet.api.users.validation.UserRegisterDtoValidator;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/user"})
@Tag(name="users", description="User operations")
public class RegisterApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired(required=false)
    SecurityProviderConfiguration securityProviderConfiguration;
    @Autowired
    FeedbackLanguages feedbackLanguages;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    SettingManager settingManager;

    @Operation(summary="Create user account", description="User is created with a registered user profile. username field is ignored and the email is used as username. Password is sent by email. Catalog administrator is also notified.")
    @PutMapping(value={"/actions/register"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> registerUser(@Parameter(description="User details", required=true) @RequestBody UserRegisterDto userRegisterDto, @Parameter(hidden=true) BindingResult bindingResult, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String userEmailDomain;
        List<String> emailDomainsAllowedList;
        boolean validRecaptcha;
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(locale);
        if (this.securityProviderConfiguration != null && !this.securityProviderConfiguration.isUserProfileUpdateEnabled()) {
            return new ResponseEntity((Object)messages.getString("security_provider_unsupported_functionality"), HttpStatus.PRECONDITION_FAILED);
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean selfRegistrationEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/enable");
        if (!selfRegistrationEnabled) {
            return new ResponseEntity((Object)String.format(messages.getString("self_registration_disabled"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
        if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(userRegisterDto.getCaptcha(), this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
            return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
        }
        UserRegisterDtoValidator userRegisterDtoValidator = new UserRegisterDtoValidator();
        userRegisterDtoValidator.validate(userRegisterDto, (Errors)bindingResult);
        String errorMessage = ApiUtils.processRequestValidation(bindingResult, messages);
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            return new ResponseEntity((Object)errorMessage, HttpStatus.PRECONDITION_FAILED);
        }
        String emailDomainsAllowed = this.settingManager.getValue("system/userSelfRegistration/domainsAllowed");
        if (org.springframework.util.StringUtils.hasLength((String)emailDomainsAllowed) && !(emailDomainsAllowedList = Arrays.asList(emailDomainsAllowed.split(","))).contains(userEmailDomain = userRegisterDto.getEmail().split("@")[1])) {
            return new ResponseEntity((Object)String.format(messages.getString("self_registration_no_valid_mail"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        User user = new User();
        user.setName(userRegisterDto.getName());
        user.setSurname(userRegisterDto.getSurname());
        user.setOrganisation(userRegisterDto.getOrganisation());
        user.setProfile(Profile.findProfileIgnoreCase((String)userRegisterDto.getProfile()));
        user.getAddresses().add(userRegisterDto.getAddress());
        user.getEmailAddresses().add(userRegisterDto.getEmail());
        String password = User.getRandomPassword();
        user.getSecurity().setPassword(PasswordUtil.encode((ServiceContext)context, (String)password));
        user.setUsername(user.getEmail());
        Profile requestedProfile = user.getProfile();
        user.setProfile(Profile.RegisteredUser);
        user = (User)this.userRepository.save((Object)user);
        Group targetGroup = this.getGroup();
        if (targetGroup != null) {
            UserGroup userGroup = new UserGroup().setUser(user).setGroup(targetGroup).setProfile(Profile.RegisteredUser);
            this.userGroupRepository.save((Object)userGroup);
        }
        String catalogAdminEmail = this.settingManager.getValue("system/feedback/email");
        LocalizedEmailComponent emailAdminSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "register_email_admin_subject", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        Group requestedGroup = this.getRequestedGroup(userRegisterDto.getGroup());
        LocalizedEmailComponent emailAdminMessageComponent = requestedGroup != null ? new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "register_email_group_admin_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT) : new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "register_email_admin_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        for (Locale feedbackLocale : feedbackLocales) {
            emailAdminSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.settingManager.getSiteName()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)user.getEmail()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)requestedProfile)});
            if (requestedGroup != null) {
                emailAdminMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)user.getEmail()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)requestedProfile), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, requestedGroup.getLabelTranslations().get(feedbackLocale.getISO3Language())), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)4, (Object)this.settingManager.getNodeURL()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)5, (Object)this.settingManager.getSiteName())});
                continue;
            }
            emailAdminMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)user.getEmail()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)requestedProfile), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)this.settingManager.getNodeURL()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)4, (Object)this.settingManager.getSiteName())});
        }
        LocalizedEmail adminLocalizedEmail = new LocalizedEmail(Boolean.valueOf(false));
        adminLocalizedEmail.addComponents(new LocalizedEmailComponent[]{emailAdminSubjectComponent, emailAdminMessageComponent});
        String adminSubject = adminLocalizedEmail.getParsedSubject(feedbackLocales);
        String adminMessage = adminLocalizedEmail.getParsedMessage(feedbackLocales);
        if (!MailUtil.sendMail((String)catalogAdminEmail, (String)adminSubject, (String)adminMessage, null, (SettingManager)this.settingManager).booleanValue()) {
            return new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "register_email_subject", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        LocalizedEmailComponent emailMessageComponent = requestedGroup != null ? new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "register_email_group_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT) : new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "register_email_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        for (Locale feedbackLocale : feedbackLocales) {
            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.settingManager.getSiteName()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)user.getProfile())});
            if (requestedGroup != null) {
                emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.settingManager.getSiteName()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)user.getUsername()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)password), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)4, (Object)Profile.RegisteredUser), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)5, (Object)requestedProfile), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)6, requestedGroup.getLabelTranslations().get(feedbackLocale.getISO3Language())), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)7, (Object)this.settingManager.getNodeURL()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)8, (Object)this.settingManager.getSiteName())});
                continue;
            }
            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.settingManager.getSiteName()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)2, (Object)user.getUsername()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)3, (Object)password), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)4, (Object)Profile.RegisteredUser), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)5, (Object)requestedProfile), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)6, (Object)this.settingManager.getNodeURL()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)7, (Object)this.settingManager.getSiteName())});
        }
        LocalizedEmail localizedEmail = new LocalizedEmail(Boolean.valueOf(false));
        localizedEmail.addComponents(new LocalizedEmailComponent[]{emailSubjectComponent, emailMessageComponent});
        String subject = localizedEmail.getParsedSubject(feedbackLocales);
        String message = localizedEmail.getParsedMessage(feedbackLocales);
        if (!MailUtil.sendMail((String)user.getEmail(), (String)subject, (String)message, null, (SettingManager)this.settingManager).booleanValue()) {
            return new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)String.format(messages.getString("user_registered"), user.getUsername()), HttpStatus.CREATED);
    }

    private Group getGroup() {
        Optional targetGroupOpt = this.groupRepository.findById((Object)ReservedGroup.guest.getId());
        if (targetGroupOpt.isPresent()) {
            return (Group)targetGroupOpt.get();
        }
        return null;
    }

    private Group getRequestedGroup(String requestedGroup) {
        Optional targetGroupOpt;
        Group targetGroup = null;
        if (org.springframework.util.StringUtils.hasLength((String)requestedGroup) && (targetGroupOpt = this.groupRepository.findById((Object)Integer.parseInt(requestedGroup))).isPresent() && !((Group)targetGroupOpt.get()).isReserved()) {
            targetGroup = (Group)targetGroupOpt.get();
        }
        return targetGroup;
    }
}

