/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.IntCollection;
import bak.pcj.IntIterator;
import bak.pcj.set.AbstractIntSet;
import bak.pcj.set.IntSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IntBitSet
extends AbstractIntSet
implements IntSortedSet,
Cloneable,
Serializable {
    private static final int BITS_PER_LONG = 64;
    private static final int BIT_MASK = 63;
    private static final int BIT_MASK_BITS = 6;
    private static final int DEFAULT_CAPACITY = 64;
    private long[] data;
    private int size;

    public IntBitSet(int maximum) {
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        this.data = new long[1 + IntBitSet.longIndex(maximum)];
        this.size = 0;
    }

    public IntBitSet() {
        this(64);
    }

    public IntBitSet(IntCollection c) {
        this();
        this.addAll(c);
    }

    public IntBitSet(int[] a) {
        this(IntBitSet.amax(a));
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    private static int amax(int[] a) {
        int max = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    private static int longIndex(int index) {
        return index >> 6;
    }

    private static int bitIndex(int index) {
        return index & 0x3F;
    }

    private static long bit(int bitno) {
        return 1L << bitno;
    }

    private static int largestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return bitIndex;
    }

    private static int smallestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 0;
        long bit = 1L;
        while ((v & bit) == 0L) {
            ++bitIndex;
            bit <<= 1;
        }
        return bitIndex;
    }

    private static int countBits(long v) {
        int count = 0;
        int bitIndex = 0;
        long bit = 1L;
        do {
            if ((v & bit) != 0L) {
                ++count;
            }
            bit <<= 1;
        } while (++bitIndex < 64);
        return count;
    }

    private static long lowMask(int n) {
        long v = 0L;
        int i = 0;
        while (i < n) {
            v = v << 1 | 1L;
            ++i;
        }
        return v;
    }

    private static long highMask(int n) {
        return IntBitSet.lowMask(n) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void ensureCapacity(int maximum) {
        int newcapacity;
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        if (this.data.length < (newcapacity = 1 + IntBitSet.longIndex(maximum))) {
            long[] newdata = new long[newcapacity];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public boolean add(int value) {
        long bit;
        boolean result;
        int longIndex;
        if (value < 0) {
            Exceptions.negativeArgument("value", String.valueOf(value));
        }
        if (this.data.length < 1 + (longIndex = IntBitSet.longIndex(value))) {
            this.ensureCapacity(value);
        }
        boolean bl = result = (this.data[longIndex] & (bit = IntBitSet.bit(IntBitSet.bitIndex(value)))) == 0L;
        if (result) {
            ++this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] | bit;
        return result;
    }

    public IntIterator iterator() {
        if (this.size == 0) {
            return new IntIterator(){

                public boolean hasNext() {
                    return false;
                }

                public int next() {
                    Exceptions.endOfIterator();
                    throw new RuntimeException();
                }

                public void remove() {
                    Exceptions.noElementToRemove();
                }
            };
        }
        return new IntIterator(){
            int nextLongIndex = this.nextLongIndex(0);
            int nextBitIndex = this.nextLongIndex < IntBitSet.access$000(IntBitSet.this).length ? this.nextBitIndex(this.nextLongIndex, 0) : 0;
            int lastValue = -1;

            int nextLongIndex(int index) {
                while (index < IntBitSet.this.data.length && IntBitSet.this.data[index] == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = IntBitSet.this.data[longIndex];
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return this.nextLongIndex < IntBitSet.this.data.length;
            }

            public int next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = this.nextLongIndex * 64 + this.nextBitIndex;
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < IntBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                IntBitSet.this.remove(this.lastValue);
                this.lastValue = -1;
            }
        };
    }

    public void trimToSize() {
        int n = this.data.length - 1;
        while (n >= 0 && this.data[n] == 0L) {
            --n;
        }
        if (n < this.data.length - 1) {
            long[] newdata = new long[1 + n];
            System.arraycopy(this.data, 0, newdata, 0, newdata.length);
            this.data = newdata;
        }
    }

    public Object clone() {
        try {
            IntBitSet c = (IntBitSet)super.clone();
            c.data = new long[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 0L;
            ++i;
        }
        this.size = 0;
    }

    public boolean contains(int value) {
        if (value < 0) {
            return false;
        }
        int longIndex = IntBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = IntBitSet.bit(IntBitSet.bitIndex(value));
        return (this.data[longIndex] & bit) != 0L;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(int value) {
        boolean result;
        if (value < 0) {
            return false;
        }
        int longIndex = IntBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = IntBitSet.bit(IntBitSet.bitIndex(value));
        boolean bl = result = (this.data[longIndex] & bit) != 0L;
        if (result) {
            --this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public int size() {
        return this.size;
    }

    private int firstFrom(int from) {
        int longIndex;
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        if ((longIndex = IntBitSet.longIndex(from)) >= this.data.length) {
            Exceptions.setNoFirst();
        }
        long v = this.data[longIndex];
        v &= IntBitSet.highMask(IntBitSet.bitIndex(from));
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = IntBitSet.smallestBitIndexOf(v);
                    return 64 * longIndex + bitIndex;
                }
                v = this.data[++longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoFirst();
            throw new RuntimeException();
        }
    }

    public int first() {
        return this.firstFrom(0);
    }

    private int lastFrom(int from) {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = Math.min(IntBitSet.longIndex(from), this.data.length - 1);
        long v = this.data[longIndex];
        v &= IntBitSet.lowMask(IntBitSet.bitIndex(from) + 1);
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = IntBitSet.largestBitIndexOf(v);
                    return 64 * longIndex + bitIndex;
                }
                v = this.data[--longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoLast();
            throw new RuntimeException();
        }
    }

    public int last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = this.data.length - 1;
        while (this.data[longIndex] == 0L) {
            --longIndex;
        }
        long v = this.data[longIndex];
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return 64 * longIndex + bitIndex;
    }

    public IntSortedSet headSet(int to) {
        return new SubSet(false, 0, true, to);
    }

    public IntSortedSet tailSet(int from) {
        return new SubSet(true, from, false, 0);
    }

    public IntSortedSet subSet(int from, int to) {
        return new SubSet(true, from, true, to);
    }

    private class SubSet
    extends AbstractIntSet
    implements IntSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private int lowerBound;
        private int upperBound;

        SubSet(boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(int v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return IntBitSet.this.add(v);
        }

        public boolean remove(int v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return IntBitSet.this.remove(v);
        }

        public boolean contains(int v) {
            return this.inSubRange(v) && IntBitSet.this.contains(v);
        }

        public IntIterator iterator() {
            return new SubSetIterator();
        }

        public int size() {
            int size;
            int longIndexLow;
            if (IntBitSet.this.size() == 0) {
                return 0;
            }
            try {
                longIndexLow = IntBitSet.longIndex(this.first());
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            int longIndexHigh = IntBitSet.longIndex(this.last());
            if (longIndexLow == longIndexHigh) {
                long v = IntBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    v &= IntBitSet.highMask(IntBitSet.bitIndex(this.lowerBound));
                }
                if (this.hasUpperBound) {
                    v &= IntBitSet.lowMask(IntBitSet.bitIndex(this.upperBound));
                }
                size = IntBitSet.countBits(v);
            } else {
                long vLow = IntBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    vLow &= IntBitSet.highMask(IntBitSet.bitIndex(this.lowerBound));
                }
                long vHigh = IntBitSet.this.data[longIndexHigh];
                if (this.hasUpperBound) {
                    vHigh &= IntBitSet.lowMask(IntBitSet.bitIndex(this.upperBound));
                }
                size = IntBitSet.countBits(vLow) + IntBitSet.countBits(vHigh);
                int i = longIndexLow + 1;
                while (i < longIndexHigh) {
                    size += IntBitSet.countBits(IntBitSet.this.data[i]);
                    ++i;
                }
            }
            return size;
        }

        public int first() {
            int first = IntBitSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : 0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public int last() {
            int last = IntBitSet.this.lastFrom(this.hasUpperBound ? this.upperBound - 1 : IntBitSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public IntSortedSet headSet(int to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public IntSortedSet tailSet(int from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public IntSortedSet subSet(int from, int to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(int v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class SubSetIterator
        implements IntIterator {
            int longIndexLow;
            int longIndexHigh;
            long vLow;
            long vHigh;
            boolean isEmpty = false;
            int nextLongIndex;
            int nextBitIndex;
            int lastValue = -1;

            SubSetIterator() {
                try {
                    this.longIndexLow = IntBitSet.longIndex(SubSet.this.first());
                }
                catch (NoSuchElementException e) {
                    this.isEmpty = true;
                }
                if (!this.isEmpty) {
                    this.longIndexHigh = IntBitSet.longIndex(SubSet.this.last());
                    if (this.longIndexLow == this.longIndexHigh) {
                        long v = IntBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            v &= IntBitSet.highMask(IntBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        if (SubSet.this.hasUpperBound) {
                            v &= IntBitSet.lowMask(IntBitSet.bitIndex(SubSet.this.upperBound));
                        }
                        IntBitSet.this.size = IntBitSet.countBits(v);
                        this.vLow = this.vHigh = v;
                    } else {
                        this.vLow = IntBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            this.vLow &= IntBitSet.highMask(IntBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        this.vHigh = IntBitSet.this.data[this.longIndexHigh];
                        if (SubSet.this.hasUpperBound) {
                            this.vHigh &= IntBitSet.lowMask(IntBitSet.bitIndex(SubSet.this.upperBound));
                        }
                    }
                    this.nextLongIndex = this.longIndexLow;
                    this.nextBitIndex = IntBitSet.smallestBitIndexOf(this.vLow);
                }
            }

            long data(int longIndex) {
                if (longIndex == this.longIndexLow) {
                    return this.vLow;
                }
                if (longIndex == this.longIndexHigh) {
                    return this.vHigh;
                }
                return IntBitSet.this.data[longIndex];
            }

            int nextLongIndex(int index) {
                while (index <= this.longIndexHigh && this.data(index) == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = this.data(longIndex);
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return !this.isEmpty && this.nextLongIndex <= this.longIndexHigh;
            }

            public int next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = this.nextLongIndex * 64 + this.nextBitIndex;
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < IntBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                IntBitSet.this.remove(this.lastValue);
                this.lastValue = -1;
            }
        }
    }
}

