/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.LongCollection;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.FloatKeyLongMap;
import bak.pcj.map.FloatKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatKeyLongMap
implements FloatKeyLongMap {
    protected AbstractFloatKeyLongMap() {
    }

    public void clear() {
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public long remove(float key) {
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            long value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultLong();
    }

    public void putAll(FloatKeyLongMap map) {
        FloatKeyLongMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(float key) {
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public long get(float key) {
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultLong();
    }

    public boolean containsValue(long value) {
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatKeyLongMap)) {
            return false;
        }
        FloatKeyLongMap map = (FloatKeyLongMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            float k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultFloatHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultLongHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public long tget(float key) {
        long value = this.get(key);
        if (value == MapDefaults.defaultLong() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        FloatKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract LongCollection values();

    public abstract long put(float var1, long var2);

    public abstract long lget();

    public abstract FloatSet keySet();

    public abstract FloatKeyLongMapIterator entries();
}

