/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractBooleanCollection;
import bak.pcj.BooleanCollection;
import bak.pcj.BooleanIterator;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.list.BooleanList;
import bak.pcj.list.BooleanListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractBooleanList
extends AbstractBooleanCollection
implements BooleanList {
    protected AbstractBooleanList() {
    }

    public boolean add(boolean v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, boolean v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, BooleanCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        BooleanIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(boolean c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, boolean c) {
        BooleanListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public BooleanIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(boolean c) {
        BooleanListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, boolean c) {
        BooleanListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    public BooleanListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new BooleanListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractBooleanList.this.size();
            }

            public boolean next() {
                if (this.ptr == AbstractBooleanList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractBooleanList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractBooleanList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(boolean v) {
                AbstractBooleanList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public boolean previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractBooleanList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(boolean v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractBooleanList.this.set(this.lptr, v);
            }
        };
    }

    public boolean removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanList)) {
            return false;
        }
        BooleanListIterator i1 = this.listIterator();
        BooleanListIterator i2 = ((BooleanList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        BooleanIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultBooleanHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract boolean set(int var1, boolean var2);

    public abstract boolean get(int var1);
}

