/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.ByteSetToSetAdapter;
import bak.pcj.adapter.ShortCollectionToCollectionAdapter;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.ByteKeyShortMap;
import bak.pcj.map.ByteKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ByteKeyShortMapToMapAdapter
implements Map {
    protected ByteKeyShortMap map;

    public ByteKeyShortMapToMapAdapter(ByteKeyShortMap map) throws NullPointerException {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) throws NullPointerException, ClassCastException {
        return this.map.containsKey((Byte)key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.map.containsValue((Short)value);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getKey() == null) {
                return false;
            }
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) throws NullPointerException, ClassCastException {
        byte k = (Byte)key;
        short v = this.map.get(k);
        if (v == MapDefaults.defaultShort() && !this.map.containsKey(k)) {
            return null;
        }
        return new Short(v);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return new ByteSetToSetAdapter(this.map.keySet());
    }

    public Object put(Object key, Object value) throws NullPointerException, ClassCastException {
        Object result = this.get(key);
        byte k = (Byte)key;
        this.map.put(k, (Short)value);
        return result;
    }

    public void putAll(Map map) throws NullPointerException, ClassCastException {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        if (!(key instanceof Byte)) {
            return null;
        }
        Object result = this.get(key);
        byte k = (Byte)key;
        this.map.remove(k);
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return new ShortCollectionToCollectionAdapter(this.map.values());
    }

    class Entry
    implements Map.Entry {
        Byte key;
        Short value;

        Entry(byte key, short value) {
            this.key = new Byte(key);
            this.value = new Short(value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return ByteKeyShortMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return DefaultByteHashFunction.INSTANCE.hash(this.key) ^ DefaultShortHashFunction.INSTANCE.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                ByteKeyShortMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            ByteKeyShortMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return ByteKeyShortMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ ByteKeyShortMapToMapAdapter access$000(EntrySet x0) {
            return x0.ByteKeyShortMapToMapAdapter.this;
        }
    }
}

