/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import org.geotools.tile.TileIdentifier;
import org.geotools.tile.impl.ZoomLevel;

class WMTSTileIdentifier
extends TileIdentifier {
    public WMTSTileIdentifier(int x, int y, ZoomLevel zoomLevel, String serviceName) {
        super(x, y, zoomLevel, serviceName);
    }

    public String getId() {
        String separator = "_";
        StringBuilder sb = this.createGenericCodeBuilder("_");
        sb.insert(0, "_").insert(0, this.getServiceName());
        return sb.toString();
    }

    public String getCode() {
        String separator = "/";
        return this.createGenericCodeBuilder("/").toString();
    }

    private StringBuilder createGenericCodeBuilder(String separator) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getZ()).append(separator).append(this.getX()).append(separator).append(this.getY());
        return sb;
    }

    public TileIdentifier getRightNeighbour() {
        int newX = this.getX() + 1;
        if (newX >= this.getZoomLevel().getMaxTilePerRowNumber()) {
            return null;
        }
        return new WMTSTileIdentifier(newX, this.getY(), this.getZoomLevel(), this.getServiceName());
    }

    public TileIdentifier getLowerNeighbour() {
        int newY = this.getY() + 1;
        if (newY >= this.getZoomLevel().getMaxTilePerColNumber()) {
            return null;
        }
        return new WMTSTileIdentifier(this.getX(), newY, this.getZoomLevel(), this.getServiceName());
    }
}

